/***************************************************************************
                          gnomemeeting.h  -  description
                             -------------------
    begin                : Fri Mar 21 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GNOMEMEETING_H
#define GNOMEMEETING_H

#include <qwidget.h>
#include "mimeapplication.h"

// Forward declarations
class MimeMessage;

/**
 * Start a meeting with the contact.
 *
 * @author Mike K. Bennett
 * @ingroup Applications
 */
class GnomeMeeting : public MimeApplication
{
  Q_OBJECT

  public:
    // The constructor
                           GnomeMeeting(const QString &contactHandle);
    // The destructor
                          ~GnomeMeeting();
    // Return the application's GUID
    static                 QString getAppId();

  private: // Private methods
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Start the meeting
    void                   startMeeting( bool connectToRemote );
    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage& message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();

  private: // Private attributes
    // The remote IP address
    QString                remoteIp_;
};

#endif
