/***************************************************************************
                          voiceconversion.cpp  -  description
                             -------------------
    begin                : 1230 2003
    copyright            : (C) 2003 by Mike K. Bennett (C)2004 by Steve gigijoe
    email                : mkb137b@hotmail.com, stevegigijoe@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SIPCONNECTION_H
#define SIPCONNECTION_H

#include <qobject.h>

class SipClient;
class SipUser;
class SipCall;
class SipCallMember;
class CallAudio;

class UserAgent : public QObject
{
  Q_OBJECT

  public:
    UserAgent(QString localIP, unsigned sipListenPort, unsigned rtpListenPort);
    ~UserAgent();

    void outgoingCall(QString strRemoteUri);
    void incomingCall();
    void releaseCall();
    bool audioCheck();

  private:
    
    void releaseCallForce();
    void destructCall();

  protected:
  
    SipClient     *client;
    SipUser       *user;
    SipCall       *call;
    SipCallMember *member;
    CallAudio     *audio;    
  
  private slots:

    void socketEventHandler();
    void audioOutputDead();
    void incomingCall(SipCall *_call, QString body );
    void callMemberStatusUpdated();
};

#endif

