/***************************************************************************
                          passportloginservice.h  -  description
                             -------------------
    begin                : Sun Apr 22 2007
    copyright            : (C) 2007 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SSLLOGINHANDLER_H
#define SSLLOGINHANDLER_H

#include "httpsoapconnection.h"


/**
 * @brief SOAP calls to the passport authentication service.
 *
 * This class is used by the MsnNotificationConnection to retrieve
 * the authentication tokens. These tokens are used to login to the
 * MSN Messenger service.
 *
 * This replaces the SSL-based Passport 1.4 login.
 * The old class used a simple HTTP header to send results,
 * this class has to send an large XML blob instead.
 * The webservice is actually called "RST", which likely stands
 * for "Request Security Token" considering the XML contents.
 *
 * For additional documentation about Passport 3.0, see
 * http://msnpiki.msnfanatic.com/index.php/MSNP13:SOAPTweener
 *
 * @author Diederik van der Boor
 * @ingroup NetworkSoap
 */
class PassportLoginService : public HttpSoapConnection
{
  Q_OBJECT

  public:
    // The constructor
                         PassportLoginService( QObject *parent = 0 );
    // The destructor
                        ~PassportLoginService();
    // Start the login process
    void                 login( const QString &parameters, const QString &handle, const QString &password );

  private:
    // Parse the HTTP header
    bool                 parseHttpHeader( const QString &preamble, const MimeMessage &header );
    // Parse the SOAP fault
    void                 parseSoapFault( const QDomElement &resultRoot, const QDomElement &headerNode );
    // Process server responses
    void                 parseSoapResult( const QDomElement &resultRoot, const QDomElement &headerNode );
    // Send the authentication request
    void                 requestMultipleSecurityTokens();

  private : // Private attributes
    /// The list of parameters sent by the notification server
    QString              authenticationParameters_;
    /// The user's handle
    QString              handle_;
    /// The user's password
    QString              password_;
    /// The number of redirects made
    int                  redirects_;

  signals : // Public signals
    /**
     * @brief Fired when the login failed because a wrong username/password was used.
     */
    void                 loginIncorrect();

    /**
     * @brief Fired when the login succeeded.
     */
    void                 loginSucceeded( QString authentication );
};

#endif
