/***************************************************************************
                          accountswidget.h  -  description
                             -------------------
    begin                : 03-08-2004
    copyright            : (C) 2004 by Madelman
                           (C) 2006 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACCOUNTSWIDGET_H
#define ACCOUNTSWIDGET_H


#include "accountswidgetinterface.h"
#include "../account.h"

#include <qstring.h>
#include <qpixmap.h>


class AccountsWidget : public AccountsWidgetInterface
{
  Q_OBJECT

  public:
    // Constructor
                       AccountsWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    // Destructor
    virtual           ~AccountsWidget();
    // Return the filename of the currently selected image.
    QString            getPictureFileName() const;
    // Request to load the settings
    void               loadSettings( Account *account, bool isCurrentAccount );
    // Request to save the settings
    void               saveSettings( Account *account );

  public slots:
    // Show the normal browse dialog to change display picture
    void               pictureBrowseSimple();
    // Show the browse dialog to change display picture and then allow the user to crop it
    void               pictureBrowseResize();
    // The user toggled the remember me option
    void               rememberMeToggled(bool noGuest);
    // The user pressed the browse image button
    void               selectImage( bool resize );
    // The user togged the show image checkbox
    void               showImageToggled(bool noImage);
    // The user pressed the "Create new account" button
    void               showRegisterPassport();

  private:
    // The handle of the account
    QString            myHandle_;
    // The image file of the account
    QString            imageFile_;
    // The location for the custom image.
    QString            tempImageFile_;
    // Do we have a custom image or not?
    bool               hasTempImage_;
    // The pixmap for the default kmess icon
    QPixmap            defaultPixmap_;
    // The pixmap for the custom user icon
    QPixmap            customPixmap_;
};

#endif // ACCOUNTSWIDGET_H
