/***************************************************************************
*   Copyright (C) 2005 by Christian Hubinger   *
*   e9806056@student.tuwien.ac.at   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/


#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>
#include <dcopclient.h>
#include "kmfiptinterface.h"
#include "version.h"
static const char description[] =
    I18N_NOOP( "A KDE KPart Application" );

static const char version[] = "0.1";

static KCmdLineOptions options[] =
    {
        KCmdLineLastOption
    };

int main ( int argc, char *argv[] ) {
	KLocale::setMainCatalogue( "kdelibs" );
	KAboutData aboutdata( "kmfiptinterface", I18N_NOOP( "KDE" ),
	                      version, description,
	                      KAboutData::License_GPL, "(C) 2001, Christian Hubinger" );
	aboutdata.addAuthor( "Christian Hubinger", I18N_NOOP( "Developer" ), "e9806056@student.tuwien.ac.at" );

	KCmdLineArgs::init( argc, argv, &aboutdata );
	KCmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();
	kdDebug() << "Starting up...!" << endl;
	if ( ! KUniqueApplication::start() ) {
		kdDebug() << "kmfiptinterface is already running!" << endl;
		return ( 0 );
	}

	KUniqueApplication app;
	kdDebug() << "starting kmfiptinterface " << endl;
	// This app is started automatically, no need for session management
	app.dcopClient() ->setAcceptCalls( true );
	kdDebug() << app.dcopClient() ->appId() << endl;
	kdDebug() << "starting kmfiptinterface " << endl;

	app.disableSessionManagement();
	/*KMFIPTInterface *service =*/ new KMFIPTInterface;
	return app.exec();

}
