/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/
#include "kmfnetzonelist.h"

namespace KMF {

KMFNetZoneList::KMFNetZoneList() : QPtrList<KMFNetZone>()
{
}


KMFNetZoneList::~KMFNetZoneList()
{
}

int KMFNetZoneList::compareItems( QPtrCollection::Item item1, QPtrCollection::Item item2 ) {
	KMFNetZone* z1 = (KMFNetZone*) item1;
	KMFNetZone* z2 = (KMFNetZone*) item2;
	// KMFNetZone* z2 = static_cast<KMFNetZone>( *item2 );
	
	if ( z1->maskLength() > z2->maskLength() ) {
		return 1;
	} else if ( z1->maskLength() == z2->maskLength() ){
		return 0;
	} else {
		return -1;
	}
	
	return 0;
}

}
