/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTRANSACTION_H
#define KMFTRANSACTION_H

#include "qdict.h"
#include "qvaluelist.h"
#include "qptrlist.h"
#include "qstring.h"
#include "qobject.h"
#include "quuid.h"
#include "qguardedptr.h"


namespace KMF {
class NetfilterObject;
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KMFTransaction{
	friend class KMFUndoEngine;
	public:
    	KMFTransaction( const QString& transactionName, NetfilterObject* );
    	~KMFTransaction();
		const QString& name() const {
			return m_transactionName;
		};
		
		const QUuid& objectUuid() const {
			return m_objectUuid;
		};
		
		const QUuid& uuid() const {
			return m_uuID;
		};
		const QString& toString();
		
		const QString& undoXML() const {
			return m_undoXML;
		};
		
		const QString& redoXML() const {
			return m_redoXML;
		};
		
	private: 
		KMFTransaction();
		void commit();
		NetfilterObject* undo();
		NetfilterObject* redo();
		
	private:
		 QString m_transactionName;
		// int m_objectID;
		 QUuid m_objectUuid;
		 
		 QUuid m_uuID;
		 QString m_undoXML; 
		 QString m_redoXML; 
};
}
#endif
