//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// License: GPL
//

// Qt includes
#include <qlistbox.h>
#include <qfile.h>
#include <qdom.h>
#include <qlabel.h>
#include <qdir.h>
#include <qpushbutton.h>

// KDE includes
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>

// project includes
#include "../core/kmfconfig.h"
#include "xmlnames.h"

#include "kmftemplatechooser.h"
namespace KMF {
KMFTemplateChooser::KMFTemplateChooser(QWidget* parent, const char* name, bool modal, WFlags fl) : KMyFirewallTemplateChooser(parent,name, modal,fl) {
	connect( lb_templates, SIGNAL( highlighted ( int ) ), 
		this, SLOT( slotNewTemplateSelected( int ) ) );
	connect( lb_templates, SIGNAL( doubleClicked( QListBoxItem* ) ), 
		this, SLOT( slotNewTemplateSelected( QListBoxItem* ) ) );
	connect( b_help, SIGNAL( clicked() ),
		this, SLOT( slotHelp() ) );

	parseTemplates();
	b_accept->setEnabled( false );
}

KMFTemplateChooser::~KMFTemplateChooser() {}

/*$SPECIALIZATION$*/
void KMFTemplateChooser::reject() {
	QDialog::reject();
}

void KMFTemplateChooser::accept() {
	if ( lb_templates->currentItem() == -1 ) {
		KMessageBox::error( this, i18n("No Template selected.") );
		return;
	}
	if ( *m_templateFilePaths.at( lb_templates->currentItem() ) == "-1" ) {
		// emit sigLoadEmptyDocument();
	} else {
		emit sigLoadTemplate( *m_templateFilePaths.at( lb_templates->currentItem() ) );
	}
	QDialog::accept();
}

void KMFTemplateChooser::slotHelp() {
	// kdDebug() << "void KMFTemplateChooser::slotHelp()" << endl;
	kapp->invokeHelp();
}

void KMFTemplateChooser::slotNewTemplateSelected( QListBoxItem* i ){
	// kdDebug() << "void KMFTemplateChooser::slotNewTemplateSelected( " << index  << " )" << endl;
	slotNewTemplateSelected( lb_templates->index( i ) );
	accept();
}

void KMFTemplateChooser::slotNewTemplateSelected( int index ){
	// kdDebug() << "void KMFTemplateChooser::slotNewTemplateSelected( " << index  << " )" << endl;
	b_accept->setEnabled( true );
	lbl_description->setText( *m_templateDescriptions.at( index ) );
}



void KMFTemplateChooser::parseTemplates(){
	lb_templates->clear();
	lbl_description->clear();
	
	// Add Empty template
	lb_templates->insertItem( i18n("Empty Ruleset") );
	m_templateFilePaths.append( "-1" );
	if ( KMFConfig::useGenericInterface() ) {
		m_templateDescriptions.append( i18n("Clean Ruleset that does only setup connection tracking e.g block everything not related to connections you initialised.") );
	} else {
		m_templateDescriptions.append( i18n("Clean Ruleset that does not do anything. Use this if you like to setup your firewall from scratch.") );
	}
	
	KStandardDirs std_dir;
	QString tmp_dir = std_dir.findResourceDir( "data", "kmyfirewall/templates/" );
	
	QDir dir( tmp_dir + "/kmyfirewall/templates/" );
	kdDebug() << "Found Data dir at: " << dir.path() << endl;
	QString type;
	if ( KMFConfig::useGenericInterface() ) {
		type = "*.tkmfgrs";
	} else {
		type = "*.tkmfrs";
	}
	QStringList templates = dir.entryList( type );
	if ( templates.isEmpty() ) {
		KMessageBox::information( this, i18n("No templates (%1) could be found; please check your installation.").arg( type ) );
		return;
	}
	for ( QStringList::Iterator it = templates.begin(); it != templates.end(); ++it ) {
        parseFile( dir.path() + "/" + *it );
    }
}

void KMFTemplateChooser::parseFile( const QString& file ) {
	// kdDebug() << "Parsing Template: " << file << endl;
	QFile f( file );
	
	if ( !f.open( IO_ReadOnly ) ) {
		KMessageBox::information( this, i18n("Template %1 could not be opened.").arg( file ) );
		return;
	}
	
	QDomDocument doc;
	if ( !doc.setContent( &f ) ) {
		f.close();
		KMessageBox::information( this, i18n("Template %1 is not a valid XML document.").arg( file ) );
		return;
	}
	
	QDomElement root = doc.documentElement();
	QDomNodeList list = root.elementsByTagName ( XML::Abstract_Element );
	if ( list.count() == 0 ) {
		KMessageBox::information( this, i18n("Template %1 does not contain the \"abstract\" tag.").arg( file ) );
		return;
	}
	QDomNode node = list.item( 0 );
	QString desc = node.toElement().attribute( XML::Description_Attribute );
	QString name = node.toElement().attribute( XML::Name_Attribute );
	lb_templates->insertItem( name );
	m_templateFilePaths.append( file );
	m_templateDescriptions.append( desc );
}

}

#include "kmftemplatechooser.moc"

