// -*- Mode: C++; -*-
/***************************************************************************
                          addmysqlhost.h  -  description
                             -------------------
    begin                : Mon Sep 29 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDMYSQLHOST_H
#define ADDMYSQLHOST_H

#include <qwidget.h>
#include <addmysqlhostdata.h>
#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"

/**
  *@author Rajko Albrecht
  */
class CAddmysqlhost : public CAddmysqlhostdata  {
    Q_OBJECT
public:
    CAddmysqlhost(smart_pointer<CMySql>& _sql_server,QWidget *parent=0, const char *name=0);
    CAddmysqlhost(smart_pointer<CMySql>& _sql_server, const std::string&aHost, const std::string& aDb, const stringlist&aRights,bool aGrant,QWidget *parent=0, const char *name=0);
    ~CAddmysqlhost();
    const std::string host()const{return m_host;}
    const std::string db()const{return m_db;}
    const stringlist rights()const{return m_right_list;}

protected:
    virtual void init_list();
    virtual void check_ok();
    virtual void init_all();

    bool m_grant;
    bool m_all_rights;
    bool m_right_set;

    stringlist m_right_list;
    std::string m_host;
    std::string m_db;
    smart_pointer<CMySql> sql_server;

protected slots:
    virtual void all_rights_changed(bool);
    virtual void grant_changed(bool);
    virtual void rights_selection_changed();
    virtual void hname_changed(const QString&);
    virtual void db_name_changed(const QString&);
    virtual void accept();
};

#endif
