#ifdef _WIN32
#pragma warning ( disable : 4786 )
#endif

#include "scriptsplit.h"
#include "stdio.h"

#include "kmysqladmin/helpers/stringlist.h"
#include <string>
#include <utility>
#include <vector>
#include <iostream>

using namespace std;

CScriptSplit::CScriptSplit(stringlist*target,const std::string&input)
{
    target_list = target;
    input_string=input;
}

CScriptSplit::~CScriptSplit()
{

}

int CScriptSplit::convert()
{
    if (!target_list)
        return 0;
    remove_comments();
    make_commands();
    return 1;
}

int CScriptSplit::remove_comments(pos_list*semicolon_list)
{
    /* 0 - nothing
     * 1 - possible start of comment ( / )
     * 2 - inside multiline comment (/ *)
     * 3 - end of line comment (// or # or --)
     * 4 - start of ' '
     * 5 - start of " "
     * 6 - possible end of multiline comment (*)
     * 7 - open paranthesis (only when searching for commands)
     * 8 - possible start of comment ( - )
     */
    int current_state = 0;
    unsigned int i,pos;
    rpair tPair(string::npos,input_string.size());
    rvector result;
    for (i = 0; i < input_string.size();++i) {
        switch (current_state) {
        case 8: {
            switch(input_string[i]) {
            case '-':
                tPair.first=i-1;
                current_state=3;
                break;
            default:
                current_state=0;
                break;
            }
        }
        break;
        case 7:
            if (input_string[i]==')') {
                current_state = 0;
            }
            break;
        case 6:{
            if (input_string[i]=='/') {                
                current_state = 0;
                result.push_back(rpair(tPair.first,i+1));
                tPair.first=std::string::npos;
                tPair.second=input_string.size();
            } else {
                current_state = 2;
            }
        }
        break;
        case 5:{
            if (input_string[i]=='\"' && input_string[i-1]!='\\') {
                current_state = 0;
            }
        }
        break;
        case 4:{
            if (input_string[i]=='\'' && input_string[i-1]!='\\') {
                current_state = 0;
            }
        }
        break;
        case 3: {
            if (input_string[i]=='\n') {
                current_state=0;
                result.push_back(rpair(tPair.first,i));
                tPair.first=std::string::npos;
                tPair.second=input_string.size();
            }
        }
        break;
        case 2: {
            switch(input_string[i]) {
            case '*':
                current_state=6;
                break;
            default:
                break;
            }
        }
        break;
        case 1: {
            switch(input_string[i]) {
            case '*':
                tPair.first=i-1;
                current_state=2;
                break;
            case '/':
                tPair.first=i-1;
                current_state=3;
                break;
            default:
                current_state=0;
                break;
            }
        }
        break;
        case 0:
        default:{
            switch(input_string[i]) {
            case '\'':
                current_state = 4;
                tPair.first = i;
                break;
            case '\"':
                current_state = 5;
                break;
            case '#':
                current_state = 3;
                tPair.first = i;
            break;
            case '/':
                current_state = 1;
                pos = i;
                break;
            case '-':
                if (i == 0 || input_string[i-1]=='\n') {
                    current_state = 8;
                    pos = i;
                }
                break;
            case '(':
                if (semicolon_list!=0) {
                    current_state = 7;
                }
                break;
            case ';':
                if (semicolon_list!=0) {
                    semicolon_list->push_back(i+1);
                }
                break;
            default:
                break;
            }
        }
        break;
        }
    }
    if (result.size()>0) {
        string temp;
        temp=input_string.substr(0,result[0].first);
        for (i = 1; i < result.size();++i) {
            temp+=input_string.substr(result[i-1].second,result[i].first-result[i-1].second);
        }
        temp+=input_string.substr(result[i-1].second,input_string.size()-result[i-1].second);
        input_string = temp;
    }
    return 1;
}

void CScriptSplit::remove_newlines(std::string&input)
{
    size_t pos;
    while ( (pos = input.find("\n")) != string::npos) {
        input.replace(pos,1," ");
    }
    while ( (pos = input.find("\r")) != string::npos) {
        input.replace(pos,1," ");
    }
    while (input.size()&&input[0]==' ') {
        input.erase(0,1);
    }
}

int CScriptSplit::make_commands()
{
    pos_list areas;
    remove_comments(&areas);
    size_t cpos = 0;
    string tmp_string = "";
    for (unsigned int i=0;i<areas.size();++i) {
        tmp_string = input_string.substr(cpos,areas[i]-cpos);
        remove_newlines(tmp_string);
        if (tmp_string.size()==0)
            continue;
        target_list->push_back(tmp_string);
        cpos = areas[i];
    }
    tmp_string = input_string.substr(cpos,input_string.size()-cpos);
    remove_newlines(tmp_string);
    if (tmp_string.size()!=0) {
        target_list->push_back(tmp_string);
    }
    return 1;
}
