#include <stdlib.h>
#include <stdio.h>
#include <qstring.h>
#include <kapp.h>

#include "StatusView.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/setup/settings.h"
#include <qtextview.h>
#include <qdatetime.h>
#include <iostream>
#include <klocale.h>
#include <qpushbutton.h>

#define Inherited CTextViewData

using namespace std;

CStatusView::CStatusView(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    sql_server = _sql_server;
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(129);
    setCaption(head);
    setIcon(kapp->icon());
    //setMiniIcon(winId(),kapp->miniIcon());

    m_Timeout = GlobalSettings.StatusPolltime();
    timer = new QTimer(this);
    connect( timer, SIGNAL(timeout()),this, SLOT(RefreshOutput()) );
    connect( &GlobalSettings,SIGNAL(statustimer_changed(int)),this,SLOT(newTimeout(int)));
    connect( &GlobalSettings,SIGNAL(npropfont_changed()),this,SLOT(newFont()));
    OutputArea->setFont(GlobalSettings.get_nonprop_font());
}

CStatusView::~CStatusView()
{
}

void CStatusView::standalone(bool how)
{
    if (how) {
        CloseButton->show();
    } else {
        CloseButton->hide();
    }
}

QString CStatusView::up_time(const std::string&aTime)const
{
    unsigned long seconds(strtoul(aTime.c_str(),NULL,10));
    QDateTime now = QDateTime::currentDateTime();
    QDateTime diff; diff.setTime_t(now.toTime_t()-seconds);

    QString s = i18n("<p>Server uptime: %1 days %2 hours %3 min").arg(seconds/86500L).arg(seconds % 86400L / 3600L).arg(seconds % 3600L / 60L);
    s+=i18n("<br>This is since %1</p>").arg(diff.toString(Qt::LocalDate));
    return s;
}

void CStatusView::get_status()
{
    QString s;
    QString t;

    string str1;
    if (!sql_server)
        return;

    PatternList values;
    if (!sql_server->get_status(values)) {
        OutputArea->setText("<h1>Error getting status</h1>");
        return;
    }
    s = "";
    t = "<table>\n";
    QString t1,t2,t3,t4;
    t1 = t2 = t3 = t4 = "";
    for (size_t a = 0; a<values.size();++a) {
        if ( Caseequ()(values[a].std_entry(),"uptime")) {
            s+=up_time(values[a].std_pattern());
            continue;
        }
        if (Caseequ()(values[a].std_entry(),"threads_connected")) {
            t1=i18n("%1 threads connected").arg(STL_TO_QT_STRING(values[a].std_pattern()));
            continue;
        }
        if (Caseequ()(values[a].std_entry(),"threads_running")) {
            t2=i18n(", %1 active thread(s).").arg(STL_TO_QT_STRING(values[a].std_pattern()));
            continue;
        }
        if (Caseequ()(values[a].std_entry(),"threads_created")) {
            t3=i18n("<br>Server created %1 thread(s)").arg(STL_TO_QT_STRING(values[a].std_pattern()));
            continue;
        }
        if (Caseequ()(values[a].std_entry(),"threads_cached")) {
            t4=i18n(", %1 thread(s) are cached.").arg(STL_TO_QT_STRING(values[a].std_pattern()));
            continue;
        }

        t+="<tr><td>\n";
        t+=STL_TO_QT_STRING(values[a].std_entry())+"</td><td align=\"right\">"+STL_TO_QT_STRING(values[a].std_pattern());
        t+="</td></tr>\n";
    }
    t+="</table>\n";
    OutputArea->setText(s+"<p>"+t1+t2+t3+t4+"</p>"+t);
}

void CStatusView::RefreshOutput()
{
    timer->stop();
    get_status();
    timer->start(m_Timeout * 1000,TRUE);
}

void CStatusView::hide_me()
{
    timer->stop();
    hide();
}

void CStatusView::show()
{
    RefreshOutput();
    Inherited::show();
}

void CStatusView::newTimeout(int aValue)
{
    m_Timeout = aValue;
}

void CStatusView::newFont()
{
    OutputArea->setFont(GlobalSettings.get_nonprop_font());
}
