// -*- Mode: C++; -*-

#ifndef _string_helper
#define _string_helper

#include <string>
#include <functional>

std::string FormatSTLString(const char*Format,...);

//! Operator class for caseinsensitive stl-string compare
class Casecmp {
public:
    bool operator()(const std::string&,const std::string&)const;
};

//! Operator class for comparing two stl-string
/*!
 * Compares two strings in a non case-sensitive way.
 */
class Caseequ {
public:
    //! the real operator
    /*!
     *
     */
    bool operator()(const std::string&a,const std::string&b)const;
};

inline bool Caseequ::operator()(const std::string&x, const std::string&y)const
{
    return (!Casecmp()(x,y)&&!Casecmp()(y,x));
}

class Caseequif{
    std::string arg2;
public:
    explicit Caseequif(const std::string&x):arg2(x){}
    bool operator()(const std::string&x)const{return Caseequ()(x,arg2);}
};

class Bin2Hex{
    std::string arg;
    std::string result;
    static char hexconvtab[];
public:
    explicit Bin2Hex(const std::string&x);
    const std::string&operator()()const;
};

class FindCharArray{
    std::string search_string;
    bool sensitive;
    int find_no_case(const char*acontainer[])const
    {
        for (int i=0; acontainer[i]!=0; ++i) {
            if (Caseequ()(acontainer[i],search_string)) return i;
        }
        return NPOS;
    }
    int find_case(const char*acontainer[]) const
    {
        for (int i=0; acontainer[i]!=0;++i) {
            if (std::string(acontainer[i])==search_string) return i;
        }
        return NPOS;
    }
public:
    static const int NPOS=0xff;
    explicit FindCharArray(const std::string aSearchString,bool aSensitive=true)
        : search_string(aSearchString),sensitive(aSensitive)
    {
    }

    int operator()(const char*acontainer[])const
    {
        if (sensitive) {
            return find_case(acontainer);
        }
        return find_no_case(acontainer);
    }
};
#endif
