#ifndef KNAP_PLAYER
#define KNAP_PLAYER

#include <qframe.h>
#include <artsflow.h>
#include <soundserver.h> 
#include <kmedia2.h> 

#include <qtimer.h>

class QLabel;
class QPushButton;
class QSlider;

/**
 * the knap mp3 player - based loosly on the kde2 media 
 * player kaiman uses function Kaiman::initArts()
 */
class KNAP_Player
: public QFrame
{
   Q_OBJECT

   signals:
      //void songEnded();
      void nextSong();
      void prevSong();
      void playSong();

   private slots:
      void sliderVol(int i);
      void pollArts(); 
      void play();
      void getnext();
      void getprev();
      void calcSongPos();
      void songPosDown();

   public slots:
      void play(const char *);
   void stop();
   void pause();
   void setVolume(int vol);
   void seek(int);
   public:
   KNAP_Player(QWidget *parent=0,const char *name=0);
   virtual ~KNAP_Player(); 
   
   bool isPlaying() { return  _lastPolledState==Arts::posPlaying; }

   virtual QSize sizeHint();

   private:
   // no copy allowed
   KNAP_Player(const KNAP_Player &) { }
   KNAP_Player & operator==(const KNAP_Player &) { return *this; }

   bool initArts();

   QLabel *songname;
   QLabel *songinfo;

   QSlider *volume;
   QSlider *songpos;

   QPushButton *prevbtn; 
   QPushButton *playbtn; 
   QPushButton *pausebtn;
   QPushButton *stopbtn; 
   QPushButton *nextbtn; 

   bool showpos;

//   class MediaManager *_mediaManager;

   Arts::PlayObject _playObject;
   Arts::PlayObjectFactory _playObjectFactory;
   Arts::StereoVolumeControl _volumeControl;
   Arts::SimpleSoundServer _soundServer;
   int _volumeEffectID;

   int _lastPolledState; 
   int _volume;    
//   QTimer _statusPollTimer;
   QTimer _artsPollTimer;  
};


#endif // KNAP_PLAYER

