/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <math.h>
#include <kwin.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <kmessagebox.h>
#include <qclipboard.h>
#include <klocale.h>
#include <kstdaction.h>
#include "pppdata.h"
#include <qtooltip.h>
#include "docking.h"
#include "pppstats.h"
#include "knet.h"
#include <kwin.h>
#include <kaboutdata.h>
#include <kstandarddirs.h>
#include <qimage.h>
#include <qpoint.h>
#include <kdebug.h>
#include "networkdev.h"
#include "osd.h"
#include <kaboutdialog.h>
#include <khelpmenu.h>

#define Icon(x) KGlobal::instance()->iconLoader()->loadIcon(x, KIcon::Toolbar)

 extern DockWidget *dock_widget;
 extern knet *m_knet;
 DockWidget *DockWidget::dock_widget = 0;
 extern NetworkDev* networkdev;
 int window;
 DockWidget::DockWidget(QWidget *parent, const char *name, PPPStats *st)
  : KSystemTray(parent, name), stats(st)

{

	KActionCollection* actionCollection = new KActionCollection(this);

	ipFound=false;

        KStandardDirs* stddir = new KStandardDirs;

	QString both = stddir->findResource("data", "knet/pics/knet/dock_both.png");
	QString left = stddir->findResource("data", "knet/pics/knet/dock_left.png");
	QString right = stddir->findResource("data", "knet/pics/knet/dock_right.png");
	QString none = stddir->findResource("data", "knet/pics/knet/dock_none.png");
	QString discon = stddir->findResource("data", "knet/pics/knet/dock_discon.png");

        dock_none_pixmap = UserIcon(none);
        dock_left_pixmap = UserIcon(left);
        dock_right_pixmap = UserIcon(right);
        dock_both_pixmap = UserIcon(both);
	dock_discon_pixmap = UserIcon(discon);

	KAction* about = KStdAction::aboutApp(this, SLOT (showAbout()), actionCollection);
	conToProv = new KAction(i18n("Connect"), Icon("connect_creating"), 0, 0, 0, actionCollection, 0);
	disFromProv = new KAction(i18n("Disconnect"), Icon("connect_no"), 0, 0, 0, actionCollection, 0);
	setupWin = new KAction(i18n("Setup a Configuration"), Icon("configure"),0 ,0 ,0, actionCollection, 0);
	KAction* status = new KAction(i18n("Show Statistics"), Icon("identity"), 0, 0, 0, actionCollection, 0);
	docbrows = new KAction(i18n("Help and Documentation"), Icon("contents"), 0, 0, 0, actionCollection, 0);

        connect (docbrows, SIGNAL(activated()), this, SLOT(browsDoc()));
	connect (disFromProv, SIGNAL(activated()), this, SLOT(discon()));
	connect (status, SIGNAL(activated()), this, SLOT(getStatus()));
	connect (stats, SIGNAL(statsChanged(int)), SLOT(paintIcon(int)));
	connect(conToProv, SIGNAL(activated()), this, SLOT(con()));
	connect(setupWin, SIGNAL(activated()), this, SLOT(setupConfig()));
	connect(this, SIGNAL(quitSelected()), this, SLOT (quitSelected()));


	contextMenu()->clear();
	contextMenu()->insertTitle(Icon("kdsl"), i18n("KDE Broadband"), 0);
	conToProv->plug(contextMenu(), 1);
	disFromProv->plug(contextMenu(), 2);
	contextMenu()->insertSeparator(3);
	setupWin->plug(contextMenu(),4);
	status->plug(contextMenu(), 5);
	contextMenu()->insertSeparator(6);
	about->plug(contextMenu(), 7);
	docbrows->plug(contextMenu(), 8);
        balloon_timer = new QTimer(this);
    
        checkStats = new QTimer(this);       
        connect(checkStats, SIGNAL(timeout()),this, SLOT(statsRestart())); 	
        this->setMouseTracking(true);
	m_balloon = new OSDWidget(this);
	window=0;
	this->installEventFilter(this);	  
}

DockWidget::~DockWidget(){
        DockWidget::dock_widget = 0;
}

void DockWidget::quitSelected()
{
     emit setWidgets();
     emit iconDisconnect();
     m_knet->shutDown();
 }
 
void DockWidget::setupConfig()
{
	emit configSetup();
}

void DockWidget::addBalloon()
{
	
	if(m_balloon->isShown())
		return;

	if(stats->connectionStatus){
//	gpppdata.setConnectedAccount("ppp0");
//	gpppdata.setAccount("hmmmm");
	gpppdata.save();
				m_balloon->setAnchor(mapToGlobal(QPoint(0,0)));
	m_balloon->show(i18n("%1 is not\nConnected").arg(gpppdata.connectedAccount() ), gpppdata.connectedAccountIconName());
//				m_balloon->setAnchor(mapToGlobal(QPoint(0,0)));
//				m_balloon->show();
				KWin::setOnAllDesktops(m_balloon->winId(), true);
    				connect(balloon_timer, SIGNAL(timeout()),this, SLOT(hideBalloon()));
       			        balloon_timer->start(2000);
	}
	else { 

				m_balloon->setAnchor(mapToGlobal(QPoint(0,0)));
	m_balloon->show(i18n("Connected to %1").arg(gpppdata.connectedAccount() ), gpppdata.connectedAccountIconName());
        
//				m_balloon->setAnchor(mapToGlobal(QPoint(0,0)));
//				m_balloon->show();
				KWin::setOnAllDesktops(m_balloon->winId(), true);
    				connect(balloon_timer, SIGNAL(timeout()),this, SLOT(hideBalloon()));
       			        balloon_timer->start(2000);
	}
}


double round2(double x)
{
  double iport, fport;
    
  fport = modf(x,&iport);
  return fport != 0.0?iport + floor(fport*100+0.5)/100.0:x;
}

void DockWidget::getStatus(){
        connect(m_balloon, SIGNAL(hideWin()), this, SLOT (statusSetup()));
	if(window==0)
	    connect(checkStats, SIGNAL(timeout()),this, SLOT(statsRestart()));
	window = 1;
	m_balloon->setAnchor(mapToGlobal(QPoint(0,0)));

double round2(double );
double a, b;
a = round2(stats->ibytes);
//double  a = 1073741824;
b = round2(stats->obytes);
  QString istatus, ostatus, configstatus;
   
 if (a >= 1073741824)
	istatus = i18n("\n%1 gigabytes Received").arg(round2(a/1024/1024/1024));
if (a < 1073741824)
	istatus = i18n("\n%1 megabytes Received").arg(round2(a/1024/1024));
if (a < 1048576)
	istatus = i18n("\n%1 kilobytes Received").arg(round2(a/1024));
if (a <1024)
	istatus = i18n("\n%1 Bytes Received").arg(a);
if (b >= 1073741824)
	ostatus = i18n("\n%1 gigabytes Sent").arg(round2(b/1024/1024/1024));
if (b< 1073741824)
	ostatus = i18n("\n%1 megabytes Sent").arg(round2(b/1024/1024));
if (b < 1048576)
	ostatus = i18n("\n%1 kilobytes Sent").arg(round2(b/1024));
if (b <1024)
	ostatus = i18n("\n%1 Bytes Sent").arg(b); 
           configstatus=(i18n("Disconnected From %1").arg(gpppdata.connectedAccount()) );
	if((gpppdata.pppdisrunning)==FALSE)
           configstatus=(i18n("Disconnected From %1").arg(gpppdata.connectedAccount()) );
        else	
        configstatus=(i18n("Connected To %1").arg(gpppdata.connectedAccount()) );

	m_balloon->show(i18n("%1\n\nLocal IP Address is %2\nRemote IP Address is %3%4%5").arg(configstatus).arg(stats->local_ip_address).arg(stats->remote_ip_address).arg(istatus).arg(ostatus), gpppdata.connectedAccountIconName());
	KWin::setOnAllDesktops(m_balloon->winId(), true);
	if(!gpppdata.pppdisrunning)



//      KMessageBox::information(this, i18n("<qt><center><b><em><h2>Connected to %3</h2></em></b><br>Your local IP address %1<br>Remote IP address %2</center></qt>"  ).arg(stats->local_ip_address).arg(stats->remote_ip_address).arg(gpppdata.accname()));
     
//      kdsl_stats->show();
//      kdsl_stats->paintGraph();
//      kdsl_stats->take_stats();
//        connect(checkStats, SIGNAL(timeout()),this, SLOT(statsRestart()));
        checkStats->start(1000); //Change Stats Every Second
//	statsRestart();
 }

void DockWidget::hideBalloon()
{
	m_balloon->hide();
    	disconnect(balloon_timer, SIGNAL(timeout()),this, SLOT(hideBalloon()));

//	window=1;
//  QTimer::singleShot( 2000, this, SLOT(mouseTracking()) );  //waiting 10 second

}

void DockWidget::mouseTracking() {
//	window=0;
}
void DockWidget::usageMeter()
    {

    }

/** Connect */
void DockWidget::con(){
	emit iconConnect();
	conToProv->setEnabled(FALSE);
	disFromProv->setEnabled(TRUE);	
}
/** Disconnect */
void DockWidget::discon(){
	QWidget *pw = parentWidget();
        pw->show();
	disFromProv->setEnabled(FALSE);
	conToProv->setEnabled(TRUE);	
	emit iconDisconnect();
}

void DockWidget::browsDoc() 
{
  kapp->invokeHelp();
}

void DockWidget::receiveIP(){

	QWidget *pw = parentWidget();
        pw->show();
	emit iconDisconnect();
}


 
 void DockWidget::statusSetup()
 {

	disconnect(checkStats, SIGNAL(timeout()),this, SLOT(statsRestart()));
	window=0;

// 	kdsl_stats->localIPLabel->show();
//        kdsl_stats->remoteIPLabel->show();
//        kdsl_stats->connectionLabel->show();
//	kdsl_stats->take_stats();	
}
 

       
void DockWidget::statsRestart() 
{
    getStatus();
}

/** Executes the about-dialog. */
void DockWidget::showAbout(){
 KHelpMenu *mHelpMenu = new KHelpMenu( this, KGlobal::instance()->aboutData());
 mHelpMenu->aboutApplication();


//    KAboutDialog *aboutDlg;
//    aboutDlg = new KAboutDialog();
//    aboutDlg->setTitle(i18n("About Knet"));

//    aboutDlg->show();

//        AboutDialog* aboutdlg = new AboutDialog;
//	aboutdlg->resize(500,300);
//        about->setLogo(UserIcon ("kppp2") );

//	about->setAuthor( "Authored by Judd Baileys", "jbaileys@bigpond.net.au", "http://kdslbroadband.sourceforge.net", "\n\nKdsl, a frontend to pppd for xDSL connections.\n\nLicensed under the GPL General Public License\n\nA special thank-you to Diego Levrero for\nhis enhancements and Italian translations to kdsl\n" );
//        about->setVersion("Kdsl 0.4\n Broadband for KDE");
//	about->addContributor("Diego Levrero for his enhancements","","","");
//        aboutdlg->show();
}
/** Called when start terminates */
void DockWidget::connected(void){

}
/** Called when stop terminates */
void DockWidget::disconnected(void){

}

void DockWidget::paintEvent (QPaintEvent *) {
   if(this->conToProv->isEnabled()) {
   paintIcon(PPPStats::BytesNone);   
  paintIcon(PPPStats::BytesDiscon);
  }
  else
   paintIcon(PPPStats::BytesNone); 
}

void DockWidget::paintIcon (int status)
{
const QPixmap *pixmap;
          KStandardDirs *dirs = KGlobal::dirs();

	QString both = dirs->findResource("data", "knet/pics/knet/dock_both.png");
	QString left = dirs->findResource("data", "knet/pics/knet/dock_left.png");
	QString right = dirs->findResource("data", "knet/pics/knet/dock_right.png");
	QString none = dirs->findResource("data", "knet/pics/knet/dock_none.png");
	QString discon = dirs->findResource("data", "knet/pics/knet/dock_discon.png");

      dock_none_pixmap = UserIcon(none);
      dock_left_pixmap = UserIcon(left);
      dock_right_pixmap = UserIcon(right);
      dock_both_pixmap = UserIcon(both);
      dock_discon_pixmap = UserIcon(discon);

    switch(status)
      {

      case PPPStats::BytesBoth:
        pixmap = &dock_both_pixmap;
        break;
      case PPPStats::BytesIn:
        pixmap = &dock_left_pixmap;

        break;
      case PPPStats::BytesOut:
        pixmap = &dock_right_pixmap;
	
        break;
      case PPPStats::BytesNone:
  
        pixmap = &dock_none_pixmap;
        break;
	
      case PPPStats::BytesDiscon:
        default:   
        pixmap = &dock_discon_pixmap;
        break;  

      }

    bitBlt(this, 0, 0, pixmap);

    }

void DockWidget::refreshIcon()
{
update();
}

void DockWidget::take_stats() {
	QWidget *pw = parentWidget();
        pw->hide();
}

void DockWidget::stop_stats() {
	QWidget *pw = parentWidget();
        pw->show();
}

#include "docking.moc"