/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #ifndef _DOCKING_H_
#define _DOCKING_H_

#include <qpixmap.h>
#include <kapp.h>
#include <ksystemtray.h>
#include <kprocess.h>
#include <kdialog.h>
#include <kaction.h>
#include <string.h>
#include <kaboutdata.h>
#include <kaboutdialog.h>
#include <kurl.h>
#include <qtimer.h>
#include <qimage.h>
#include "osd.h"
// #include "statusDlg.h"

class OSDWidget;
class PPPStats;
class knet;
class PPPData;
class PrefDialog;
class NetworkDev;
//  class DocBrowser;
// class QPoint;
// class KHTMLPart;
// class kdslStats;

class DockWidget : public KSystemTray {
  Q_OBJECT
public:
//  DockWidget(QWidget * parent, const char *name, PPPStats *st);
   DockWidget(QWidget * parent=0, const char *name=0, PPPStats *st=0);
  ~DockWidget();

	bool ipFound;
	KAction* conToProv;
	KAction* disFromProv;
        KAction* useMeter;
        KAction* docbrows;
	KAction* setupWin;
//	KDialog* aboutDialog;
	/** Disconnect */
//        void mouseEvent(QMouseEvent *e);


/*	if( e->type() == QEvent::MouseMove) {
	if ( ( e->type() >= QEvent::MouseButtonPress &&
	       e->type() <= QEvent::FocusOut) || e->type() == QEvent::Leave )
       hideBalloon();
       return TRUE;
       }
        else {
        addBalloon();
        return FALSE;
	}
        return FALSE;
	} */	

		
signals:
	void iconDisconnect();
	void iconConnect();
	void configSetup();
	void setWidgets();
	
protected:
  void paintEvent(QPaintEvent *e);
//  virtual void mouseMoveEvent( QMouseEvent* e);
 // void QPoint ( int xpos, int ypos ) ;
 // void pos () const ; 
  
        bool eventFilter( QObject * o, QEvent * e ){
	if( e->type() == QEvent::MouseMove) {
	    QMouseEvent * m = (QMouseEvent *)e;
	    QPoint mousePos = this->pos() ;

	    if ( m->state() == 0 &&
		    mousePos.x() >= 0 && mousePos.x() < this->width() &&
		    mousePos.y() >= 0 && mousePos.y() < this->height() ) {
	addBalloon();
	return TRUE;
	}
	else {
	addBalloon();
	return FALSE;
        }

        }
	else {
//	disconnect(checkStats, SIGNAL(timeout()),this, SLOT(statsRestart()));
	return FALSE;
	}
}


private slots: // Private slots
	/** Disconnect */

	void con();
	/** Display the IP */
	void receiveIP();
	/** Try to get the IP */
	void getStatus();
	/** Show the about-dialog */
	void showAbout();
	/** Called when start terminates */
	void connected(void);
	/** Called when stop terminates */
	void disconnected(void);
	void setupConfig();
        void quitSelected();
	void browsDoc();
	void usageMeter();
	void mouseTracking();

public slots:
	void paintIcon(int);
	void take_stats();
        void stop_stats();
	void refreshIcon();
	void discon();
	void hideBalloon();
	void statsRestart();
	void statusSetup();	
	void addBalloon();
	
public:
	static DockWidget *dock_widget;
	QTimer *checkStats;

private:
	QPixmap dock_none_pixmap;
  	QPixmap dock_left_pixmap;
  	QPixmap dock_right_pixmap;
	QPixmap dock_both_pixmap;
	QPixmap dock_blank_pixmap;
	QPixmap dock_discon_pixmap;
	QImage image;
  	PPPStats *stats;
	PrefDialog *pref_dialog;
        NetworkDev* networkdev;
	knet *m_knet;
//	kdslStats *kdsl_stats;
//	Osd *osd;
//        KAboutWidget *about;	
//	char themedir;
//        DocBrowser *browser;
	int pos_x;
	int pos_y;
	OSDWidget *m_balloon;	
	QTimer *balloon_timer;

};


#endif

