/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dsldialog.h" 
#include "ethernetscan.h"
#include "ethernetConfig.h"
#include "networkConfig.h"
#include "modemscan.h"
#include "internetsetup.h"
#include "networkdev.h"
#include "prefdialog.h"
#include "openingdialog.h"
#include "internetConfig.h"
#include <ktextedit.h>
#include <klocale.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <kdebug.h>
#include <qevent.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kprocess.h>
#include "auth.h"
#include "pppdata.h"
#include "opener.h"
#include "requester.h"
#include "pppstats.h"
#include "knet.h"
#include "settingsdialog.h"

#include <kmessagebox.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <networkConfig.h>

#include <qspinbox.h>
#include <kcolorbutton.h>
#include <kfontrequester.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <kdesu/su.h>

 extern PPPStats* stats;
 extern NetworkDev* networkdev;

   PrefDialog::PrefDialog(QWidget *parent, const char *name)
 : KDialogBase(parent, name, QString::null)
  
//  PrefDialog::PrefDialog(QWidget *parent, const char *name)
// : KDialogBase(IconList, i18n("Preferences"), Ok|Apply|Cancel, NoDefault , parent, name)
{ 
//      QFrame *frame;
//      QGridLayout *frameLayout;
      
//   clearWState( WState_Polished );  
   
      QGridLayout *frameLayout;
//      frameLayout = new QGridLayout( frame, 0, 0, 0 );


   QWidget *page = new QWidget( this );
   setMainWidget(page);
      frameLayout = new QGridLayout( page, 0, 0, 0 );
//   QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

 //  QLabel *label = new QLabel( caption, page, "caption" );
//   topLayout->addWidget( label );

//   lineedit = new QLineEdit( urltext, page, "lineedit" );
//   lineedit->setMinimumWidth(fontMetrics().maxWidth()*20);
//   topLayout->addWidget( lineedit );

//   topLayout->addStretch(10);

      networkdev = new NetworkDev(page);
      frameLayout->addWidget(networkdev,0 ,0 ,0);
 //     networkdev->reparent(this,0,QPoint(0,0), true);
//      setMainWidget(networkdev);  
    resize( QSize(875, 800).expandedTo(minimumSizeHint()) ); 
//      this->show();
//      topLayout->addWidget( networkdev );
//      topLayout->addStretch(10);
    connect(this, SIGNAL( okClicked() ), this, SLOT(okClicked() ) );
    connect(networkdev->settingsdialog->testOSDButton, SIGNAL(clicked() ), this, SLOT(TestOSD() ) );
 

}
PrefDialog::~PrefDialog()
{
    //Only stop the server if we started it
}



void PrefDialog::okClicked()
{
    networkdev->page="none";
    networkdev->iterateList();	 
     networkdev->internetsetup->show();
}

void PrefDialog::enableApply()
{
    enableButtonApply(true);
}

void PrefDialog::slotApply()
{
//  KProcess* proc = new KProcess();
//   *proc << "su";
//   *proc << "These" << "are" << "the" << "command" << "line" << "args";
//   KApplication::connect(proc, SIGNAL(processExited(KProcess *)),
 //                        pointer_to_my_object, SLOT(my_objects_slot(KProcess *)));
//   proc->start();
//            if( !settingschange->checkRootPasswd() )
//                return PASSWDERROR;
if ((networkdev->page)=="none")
    return;
if ((networkdev->page)=="script")
  applyScript();
if ((networkdev->page)=="scriptnew")
  applyScript();
if ((networkdev->page)=="dsl") 
  applyDSL();
if ((networkdev->page)=="dslnew")
  applyDSL();
if ((networkdev->page)=="dialup")
  applyDialup();
if ((networkdev->page)=="dialupnew")
  applyDialup();  
if ((networkdev->page)=="modem")
  applyModem();
if ((networkdev->page)=="modemnew")
  applyNewModem();
if ((networkdev->page)=="ethernet")
  applyNetwork();

applyGeneralSettings();
}

void PrefDialog::applyNetwork()
{
       if(checkPassword(i18n("You need root permission to alter network settings\n\nEnter the root password to save these settings"))==0){
	 return;
       }

  networkdev->page="none";
}

void PrefDialog::applyDNS()
{
   gpppdata.setAutoDNS(networkdev->accountsetup->checkBox7->isChecked() );
   if (gpppdata.autoDNS()==false){
      QStringList dnslist;
      dnslist.append(networkdev->accountsetup->dns1LineEdit->text() );
      dnslist.append(networkdev->accountsetup->dns2LineEdit->text() );
      gpppdata.setDns(dnslist);
   }
}

void PrefDialog::applyScript()
{
  if (networkdev->scriptsetup->connectionNameLineEdit->text().isEmpty()) {
     KMessageBox::error(this, i18n("A name for this connection must be entered"));
     networkdev->page=="none";
     return;
  }
  if ((networkdev->page)=="scriptnew") {
     gpppdata.newaccount();  
     }
  if (gpppdata.isUniqueAccname(networkdev->scriptsetup->connectionNameLineEdit->text() )) 
        {  	
        gpppdata.setAccname(networkdev->scriptsetup->connectionNameLineEdit->text() );    
        gpppdata.setStoredUsername(networkdev->scriptsetup->usernameLineEdit->text() );
        gpppdata.setStoredPassword(networkdev->scriptsetup->passwordLineEdit->text() );
        gpppdata.setAccountIconName(networkdev->scriptsetup->iconURLRequester->url() );
        gpppdata.setStoredAccType("SCRIPT"); 
        gpppdata.setScriptArg(networkdev->scriptsetup->scriptargLineEdit->text() );
	networkdev->page="none";
        }
   emit resetaccounts();
   networkdev->iterateList();	
   slotCancel();
}

void PrefDialog::applyDSL()
{
  if (networkdev->accountsetup->connectionNameLineEdit->text().isEmpty()) {
     KMessageBox::error(this, i18n("A name for this connection must be entered"));
     networkdev->page=="none";
     return;
  }
  if ((networkdev->page)=="dslnew") {
     gpppdata.newaccount();  
     }
  if (gpppdata.isUniqueAccname(networkdev->accountsetup->connectionNameLineEdit->text() )) 
        {  	
        gpppdata.setAccname(networkdev->accountsetup->connectionNameLineEdit->text() );    
        gpppdata.setStoredUsername(networkdev->accountsetup->usernameLineEdit->text() );
        gpppdata.setStoredPassword(networkdev->accountsetup->passwordLineEdit->text() );
        gpppdata.setStoredNetwork(networkdev->accountsetup->networkLineEdit->text() );	
        gpppdata.setAccountIconName(networkdev->accountsetup->iconURLRequester->url() );
	gpppdata.setDevice(networkdev->accountsetup->kComboBox6->currentText() );
        gpppdata.setStoredAccType("DSL"); 
        gpppdata.setProtocol(networkdev->accountsetup->pluginComboBox->currentText() );
	networkdev->page="none";
        }
   applyDNS();
   applyAdvance();
   emit resetaccounts();
   networkdev->iterateList();	
   slotCancel();
}

void PrefDialog::applyDialup()
{
  if (networkdev->accountsetup->connectionNameLineEdit->text().isEmpty()) {
     KMessageBox::error(this, i18n("A name for this connection must be entered"));
     networkdev->page=="none";
     return;
  }
  if ((networkdev->page)=="dialupnew") {
     gpppdata.newaccount();
  }
  if (gpppdata.isUniqueAccname(networkdev->accountsetup->connectionNameLineEdit->text() )) 
        {  	
        gpppdata.setAccname(networkdev->accountsetup->connectionNameLineEdit->text() );    
        gpppdata.setStoredUsername(networkdev->accountsetup->usernameLineEdit->text() );
        gpppdata.setStoredPassword(networkdev->accountsetup->passwordLineEdit->text() );	
        gpppdata.setAccountIconName(networkdev->accountsetup->iconURLRequester->url() );
	gpppdata.setPhonenumber(networkdev->accountsetup->networkLineEdit->text() );
	gpppdata.setDevice(networkdev->accountsetup->kComboBox6->currentText() );
        gpppdata.setStoredAccType("dialup"); 
	networkdev->page="none";
        }
   applyDNS();
   applyAdvance();
   emit resetaccounts();
   networkdev->iterateList();	
   slotCancel();	
	   
}

void PrefDialog::applyAdvance()
{
	gpppdata.set_defaultroute(networkdev->accountsetup->defaultrouteCheckBox->isChecked() );
	gpppdata.set_noauth(networkdev->accountsetup->noauthCheckBox->isChecked() );
	gpppdata.set_noccp(networkdev->accountsetup->noccpCheckBox->isChecked() );
	gpppdata.set_nopcomp(networkdev->accountsetup->nopcompCheckBox->isChecked() );	
	gpppdata.set_novj(networkdev->accountsetup->novjCheckBox->isChecked() );
        gpppdata.set_novjccomp(networkdev->accountsetup->novjccompCheckBox->isChecked() );
        gpppdata.set_noipdefault(networkdev->accountsetup->noipdefaultCheckBox->isChecked() );
        gpppdata.set_nobsdcomp(networkdev->accountsetup->nobsdcompCheckBox->isChecked() );
        gpppdata.set_nodeflate(networkdev->accountsetup->nodeflateCheckBox->isChecked() );
        gpppdata.set_persist(networkdev->accountsetup->persistCheckBox->isChecked() );
        gpppdata.set_holdoff(networkdev->accountsetup->holdoffSpinBox->value() );
        gpppdata.set_maxfail(networkdev->accountsetup->maxfailSpinBox->value() );
        gpppdata.set_mru(networkdev->accountsetup->mruSpinBox->value() );
        gpppdata.set_mtu(networkdev->accountsetup->mtuSpinBox->value() );
        gpppdata.set_vci(networkdev->accountsetup->vciSpinBox->value() );
        gpppdata.set_vpi(networkdev->accountsetup->vpiSpinBox->value() );
        gpppdata.set_echo_interval(networkdev->accountsetup->echointervalSpinBox->value() );
        gpppdata.set_echo_failure(networkdev->accountsetup->echofailureSpinBox->value() );
}

void PrefDialog::applyGeneralSettings()
{
       gpppdata.setStoreConnect(networkdev->settingsdialog->autoconnectCheckBox->isChecked());
       gpppdata.setStoreAutostart(networkdev->settingsdialog->autostartCheckBox->isChecked());
       gpppdata.setOSDBackgroundColor(networkdev->settingsdialog->osdBGColorButton->color() );
       gpppdata.setOSDForegroundColor(networkdev->settingsdialog->osdFontColorButton->color() );
       gpppdata.setOSDFont(networkdev->settingsdialog->kFontRequester1->font() );
       gpppdata.setTransperancy((networkdev->settingsdialog->kIntNumInput2->relativeValue()));
       gpppdata.save();
}
void PrefDialog::applyEthernet()
{

}

bool PrefDialog::checkPassword(const QString &b)
{
 QCString password;
 int result = KPasswordDialog::getPassword(password, b);
 if (result == KPasswordDialog::Accepted) {

   if(Requester::rq->checkPassword(password)==0) {
//	KMessageBox::error(this, i18n("Password was rejected"));
        checkPassword(i18n("Password was Incorrect.  Please re-enter password"));
	return false;  //Password was rejected
   }
   else
	return true;   //password was accepted
   }
   else  //Cancel Button was pressed
  return false;
}


void PrefDialog::applyNewModem()
{
        if (gpppdata.modname()==networkdev->modemscan->modemComboBox->currentText() )
        {
	   networkdev->page="none";
           networkdev->iterateList();
           slotCancel();
	   return;
        }
        if (!gpppdata.isUniqueModname(networkdev->modemscan->modemComboBox->currentText()) ) 
        {
	   networkdev->page="none";
           networkdev->iterateList();
           slotCancel();
	   return;
	}
	else
	{

           gpppdata.newmodem();
           gpppdata.setModname(networkdev->modemscan->modemComboBox->currentText());
           gpppdata.setModemDevice(networkdev->modemscan->modemComboBox->currentText());
           applyModem(); 
	   networkdev->page="none";
           networkdev->iterateList();	
           slotCancel();
	}


//  if (gpppdata.isUniqueModname(networkdev->modemscan->modemComboBox->currentText()) )
//        {  
//        gpppdata.setModname(networkdev->modemscan->modemComboBox->currentText());
//	KMessageBox::information(this, i18n("Trying to install a new modem!"));
//	gpppdata.setModem(networkdev->modemscan->modemComboBox->currentText());
//        applyModem(); 
//	networkdev->page="none";
//        }
//	else {
//	networkdev->page="none";
//	gpppdata.deleteModem();
//	}
}

void PrefDialog::applyModem()
{
    networkdev->applyModem();
    networkdev->page="none";
    applyDNS();
    applyAdvance();
    emit resetaccounts();
    networkdev->iterateList();	
    slotCancel();
}

void PrefDialog::TestOSD()
{
   emit OSDTesting();
}

void PrefDialog::slotCancel()
{
     networkdev->page=="none";
     if(networkdev->accountsetup->isShown() );
     networkdev->accountsetup->hide();
     if(networkdev->modemscan->isShown() );
     networkdev->modemscan->hide();
     if(networkdev->ethernetscan->isShown() );
     networkdev->ethernetscan->hide();
     networkdev->internetsetup->show();
     networkdev->slotInternetSetup();    

}

void PrefDialog::slotDefault() 
{

}

