/***************************************************************************
                          knightspixcache.h  -  description
                             -------------------
    begin                : Mon Aug 20 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNIGHTSPIXCACHE_H
#define KNIGHTSPIXCACHE_H

#include <qvaluelist.h>
#include <qpixmap.h>
#include <qimage.h>

/**
  *@author Troy Corbin Jr.
  */

typedef struct cacheItem
{
	QString				label;
	QPixmap				item;
	unsigned int	bytes;
	unsigned int	age;
};

typedef QValueList<cacheItem> pixmapList;

class KnightsPixCache
{
		public:
		QPixmap								SquareLight;
		QPixmap								SquareDark;
		QPixmap								HighlightSelect;
		QPixmap								HighlightMove;
		QPixmap								HighlightAttack;
		QPixmap								BlackKing;
		QPixmap								BlackQueen;
		QPixmap								BlackBishop;
		QPixmap								BlackKnight;
		QPixmap								BlackRook;
		QPixmap								BlackPawn;
		QPixmap								WhiteKing;
		QPixmap								WhiteQueen;
		QPixmap								WhiteBishop;
		QPixmap								WhiteKnight;
		QPixmap								WhiteRook;
		QPixmap								WhitePawn;
		QPixmap								Border;
		QPixmap								BorderLightOn;
		QPixmap								BorderLightOff;

		QImage								Orig_SquareLight;
		QImage								Orig_SquareDark;
		QImage								Orig_HighlightSelect;
		QImage								Orig_HighlightMove;
		QImage								Orig_HighlightAttack;
		QImage								Orig_BlackKing;
		QImage								Orig_BlackQueen;
		QImage								Orig_BlackBishop;
		QImage								Orig_BlackKnight;
		QImage								Orig_BlackRook;
		QImage								Orig_BlackPawn;
		QImage								Orig_WhiteKing;
		QImage								Orig_WhiteQueen;
		QImage								Orig_WhiteBishop;
		QImage								Orig_WhiteKnight;
		QImage								Orig_WhiteRook;
		QImage								Orig_WhitePawn;
		QImage								Orig_Border;
		QImage								Orig_BorderLightOn;
		QImage								Orig_BorderLightOff;

													KnightsPixCache();
													~KnightsPixCache();
		void									clear( void );
		void									setCacheLimit( const unsigned int &limit );
		unsigned int					cacheLimit( void );
		void									add( const QString &label, const QPixmap &pixmap );
		bool									find( const QString &label, QPixmap &pixmap);
		void									resize( const int &size );
		
		private:
		
		pixmapList						list;
		pixmapList::Iterator	IT;
		
		unsigned int					bytesUsed;
		unsigned int					bytesTotal;
		
		void									cleanCache( const unsigned int &space );
};

#endif
