/***************************************************************************
                          setpagegeneral.cpp  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kfiledialog.h>
#include <kicontheme.h>
#include "setpagegeneral.moc"

setPageGeneral::setPageGeneral(QWidget *parent, resource *Rsrc ) : QVBoxLayout(parent)
{
	Parent = parent;
	Resource = Rsrc;

	GROUP_UserName = new QGroupBox( 1,
																		Qt::Horizontal,
																		i18n( "Your Name:" ),
																		parent );
	addWidget( GROUP_UserName );
	EDIT_UserName = new KLineEdit( GROUP_UserName );
	EDIT_UserName->setText( Resource->Local_Player );
	connect( EDIT_UserName, SIGNAL( textChanged(const QString&) ), this, SLOT( slot_UserName(const QString&) ) );

	BOX_SaveInit = new QHBox( parent );
	addWidget( BOX_SaveInit );

	GROUP_OnInit = new QButtonGroup( 3, Qt::Vertical, i18n("When Knights Begins It Should:"), BOX_SaveInit );
		BUTTON_Init_Nothing = new QRadioButton( i18n( "Do Nothing" ), GROUP_OnInit );
		BUTTON_Init_VsPC = new QRadioButton( i18n( "Start a Match vs. PC" ), GROUP_OnInit );
		BUTTON_Init_Connect = new QRadioButton( i18n( "Connect to ICS" ), GROUP_OnInit );
		GROUP_OnInit->setExclusive( TRUE );
		if( Resource->OPTION_On_Init == 0 ) GROUP_OnInit->setButton( 0 );
		else if( Resource->OPTION_On_Init == MENU_VS_PC ) GROUP_OnInit->setButton( 1 );
		else GROUP_OnInit->setButton( 2 );
		connect(	GROUP_OnInit, SIGNAL( clicked(int) ),
							this, SLOT( slot_Init(int) ) );

	GROUP_AutoSave = new QButtonGroup( 3, Qt::Vertical, i18n("Save Match on Close?"), BOX_SaveInit );
		BUTTON_AutoSave_Yes = new QRadioButton( i18n( "Yes" ), GROUP_AutoSave );
		BUTTON_AutoSave_No = new QRadioButton( i18n( "No" ), GROUP_AutoSave );
		BUTTON_AutoSave_Ask = new QRadioButton( i18n( "Ask" ), GROUP_AutoSave );
		GROUP_AutoSave->setExclusive( TRUE );
		if( Resource->PromptForSaving == "Yes" ) GROUP_AutoSave->setButton( 0 );
		else if( Resource->PromptForSaving == "No" ) GROUP_AutoSave->setButton( 1 );
		else GROUP_AutoSave->setButton( 2 );
		connect(	GROUP_AutoSave, SIGNAL( clicked(int) ),
							this, SLOT( slot_AutoSave(int) ) );

	GROUP_Reuse_PGN = new QGroupBox( 2,
																		Qt::Vertical,
																		i18n( "Append to Save File:" ),
																		parent );
	addWidget( GROUP_Reuse_PGN );
	BUTTON_Reuse_PGN = new QCheckBox( i18n( "Append to Save File" ), GROUP_Reuse_PGN );
	BUTTON_Reuse_PGN->setChecked( Resource->OPTION_Reuse_PGN );
	connect(	BUTTON_Reuse_PGN, SIGNAL( toggled(bool) ),
						this, SLOT( slot_Reuse_PGN(bool) ) );

	BOX_Reuse_PGN = new QHBox( GROUP_Reuse_PGN );
	EDIT_PGN_Filename = new KLineEdit( BOX_Reuse_PGN );
	EDIT_PGN_Filename->setText( Resource->PGN_Filename );
	connect( EDIT_PGN_Filename, SIGNAL( textChanged(const QString&) ), this, SLOT( slot_PGN_Filename(const QString&) ) );
	BUTTON_PGN_Filename = new QPushButton( BOX_Reuse_PGN );
	BUTTON_PGN_Filename->setPixmap( Resource->LoadIcon( QString( "fileopen" ), KIcon::Toolbar ) );
	connect( BUTTON_PGN_Filename, SIGNAL( clicked() ), this, SLOT( slot_PGN_Filename_Button() ) );
	EDIT_PGN_Filename->setEnabled( Resource->OPTION_Reuse_PGN );
	BUTTON_PGN_Filename->setEnabled( Resource->OPTION_Reuse_PGN );

	BUTTON_Pause_On_Minimize = new QCheckBox( i18n( "Pause on Minimize" ), parent );
	BUTTON_Pause_On_Minimize->setChecked( Resource->OPTION_Pause_On_Minimize );
	connect(	BUTTON_Pause_On_Minimize, SIGNAL( toggled(bool) ),
						this, SLOT( slot_Pause_On_Minimize(bool) ) );
	addWidget( BUTTON_Pause_On_Minimize );

	BUTTON_Auto_Queen = new QCheckBox( i18n( "Always Promote to Queen" ), parent );
	BUTTON_Auto_Queen->setChecked( Resource->OPTION_Auto_Queen );
	connect(	BUTTON_Auto_Queen, SIGNAL( toggled(bool) ),
						this, SLOT( slot_Auto_Queen(bool) ) );
	addWidget( BUTTON_Auto_Queen );

	BUTTON_Auto_Flag = new QCheckBox( i18n( "Call Flag Automatically" ), parent );
	BUTTON_Auto_Flag->setChecked( Resource->OPTION_Auto_Call_Flag );
	connect(	BUTTON_Auto_Flag, SIGNAL( toggled(bool) ),
						this, SLOT( slot_Auto_Flag(bool) ) );
	addWidget( BUTTON_Auto_Flag );
}
setPageGeneral::~setPageGeneral()
{
}
///////////////////////////////////////
//
//	setPageGeneral::slot_AutoSave
//
///////////////////////////////////////
void setPageGeneral::slot_AutoSave( int state )
{
	switch( state )
	{
		case 0:
			Resource->PromptForSaving = "Yes";
			break;
		case 1:
			Resource->PromptForSaving = "No";
			break;	
		case 2:
			Resource->PromptForSaving = "";
			break;				
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_Init
//
///////////////////////////////////////
void setPageGeneral::slot_Init( int state )
{
	switch( state )
	{
		case 0:
			Resource->OPTION_On_Init = 0;
			break;
		case 1:
			Resource->OPTION_On_Init = MENU_VS_PC;
			break;	
		case 2:
			Resource->OPTION_On_Init = MENU_CONNECT;
			break;				
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_Pause_On_Minimize
//
///////////////////////////////////////
void setPageGeneral::slot_Pause_On_Minimize( bool state )
{
	Resource->OPTION_Pause_On_Minimize = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_Auto_Queen
//
///////////////////////////////////////
void setPageGeneral::slot_Auto_Queen( bool state )
{
	Resource->OPTION_Auto_Queen = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_Auto_Flag
//
///////////////////////////////////////
void setPageGeneral::slot_Auto_Flag( bool state )
{
	Resource->OPTION_Auto_Call_Flag = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_UserName
//
///////////////////////////////////////
void setPageGeneral::slot_UserName( const QString& string )
{
	Resource->Local_Player = string;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_Reuse_PGN
//
///////////////////////////////////////
void setPageGeneral::slot_Reuse_PGN( bool state )
{
	Resource->OPTION_Reuse_PGN = state;
	EDIT_PGN_Filename->setEnabled( state );
	BUTTON_PGN_Filename->setEnabled( state );
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_PGN_Filename
//
///////////////////////////////////////
void setPageGeneral::slot_PGN_Filename( const QString& string )
{
	Resource->PGN_Filename = string;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageGeneral::slot_PGN_Filename_Button
//
///////////////////////////////////////
void setPageGeneral::slot_PGN_Filename_Button( void )
{
	QString temp;

	temp = KFileDialog::getOpenFileName(	QString::null,
																				QString( "*" ),
																				BOX_Reuse_PGN,
																				i18n( "Find PGN..." ) );
	if( temp.isEmpty() ) return;
	EDIT_PGN_Filename->setText( temp );
	Resource->PGN_Filename = temp;
	emit enableApply();
}

