/***************************************************************************
                          knutprefdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprefdlg.h"
#include "knutvardata.h"
#include "knutfrontpanel.h"
#include "knutdock.h"

#include <kiconloader.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qfont.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>
 

#include <stdio.h>
//#include <iostream>

#define MAIN_PANEL_FONT 0
#define ANALOG_PANEL_FONT 1



KNutPrefDlg::KNutPrefDlg(KNutUpsData* const upsData, KNutVarData* const analogData, SettingDataDef* const settingData,
                          const QString upsName, QWidget* parent,  const char* name, const bool modal)
            :KDialogBase(IconList, i18n("Preferences"),Help|Default|Apply|Ok|Cancel,Ok, parent, name, modal, true),
                         m_activeUpsName (upsName), m_myUpsData(upsData), m_myAnalogData(analogData), m_prefData(settingData) {
          

  setName( "UpsMemberDlg" );

  m_checked = false; // no change of definition of UPS // neni zadna zmena na definici UPS
  m_checkedActiveUps = false; // change of active UPS hasn't been made // neni provedena zmena aktivni UPS

  initSetting();
  initUps();
  initPanel();
  initFonts();
  initAnalog();
  initDock(); // from 0.8 version
  setMinimumSize (450, 300);
  }


KNutPrefDlg::~KNutPrefDlg(){
  delete m_listBox2;
  }
  



/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE SLOTS                                                     */
/*                                                                                           */
/*********************************************************************************************/
  

void KNutPrefDlg::slotEnableVoltage(bool enable) { m_voltageGroup->setEnabled(!enable);}

void KNutPrefDlg::slotEnableFrequency(bool enable) { m_frequencyGroup->setEnabled(!enable);}

void KNutPrefDlg::slotUseCustomBColor(bool enable) {
  m_BGButton->setEnabled(enable);
  m_mainBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBIconColor(bool enable) {
  m_BGIButton->setEnabled(enable);
  m_dockBackgroundColorLabel->setEnabled(enable);
  }

  
void KNutPrefDlg::slotUseCustomBPanelColor(bool enable) {
  m_BGPButton->setEnabled(enable);
  m_panelBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBAnalogColor(bool enable) {
  m_BGAButton->setEnabled(enable);
  m_analogBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomOAnalogColor(bool enable) {
  m_AFingerButton->setEnabled(enable);
  m_AOKButton->setEnabled(enable);
  m_AWarnningButton->setEnabled(enable);
  m_AErrorButton->setEnabled(enable);
  m_AScaleButton->setEnabled(enable);
  m_AFontButton->setEnabled(enable);
  m_analogPointerColorLabel->setEnabled(enable);
  m_analogOKColorLabel->setEnabled(enable);
  m_analogWarningColorLabel->setEnabled(enable);
  m_analogErrorColorLabel->setEnabled(enable);
  m_analogScaleColorLabel->setEnabled(enable);
  m_analogFontColorLabel->setEnabled(enable);
  }

  

void KNutPrefDlg::slotChangeSettingFont(int index) {
  if (m_settingFont != index) {
  // vybirame jiny font
  if (m_settingFont == MAIN_PANEL_FONT) {
     m_mPanelFont=m_fontWidget->font();
     m_fontWidget->setFont(m_aPanelFont);
    }
  else {
    m_aPanelFont=m_fontWidget->font();
    m_fontWidget->setFont(m_mPanelFont);
    }
   m_settingFont = index;
  }
}



void KNutPrefDlg::slotDeleteUps() {
  if (m_listBox2->currentItem() != -1)	{
    // smazeme policko
    int ukListBox = m_listBox2->currentItem();
    if ( m_activeUpsName == m_listBox2->currentText() ) m_checkedActiveUps = true;
    m_myUpsData->deleteName(ukListBox);
    m_listBox2->removeItem(ukListBox);
    m_checked = true;
    // when active ups is deleted, will set checkedActiveUps 
    // pokud smazeme aktivni UPS nastavime checkedActiveUps
    }
  }


void KNutPrefDlg::slotEditUps() {
  if (m_listBox2->currentItem() != -1)	{
    upsRecord upsPref;
    // makes dialog
    newUpsDlg = new KNutNewUpsDlg(m_myUpsData,m_myAnalogData,false);
    // reads record
    m_myUpsData->get(m_listBox2->currentItem(),upsPref);
    // sets parameters for edit /  nastavime parametry pro edit
    newUpsDlg->putData(upsPref);
    int result = newUpsDlg->exec();
    if (result == Accepted) {
      // adds into list after OK will be clicked  
      // reads data from form
      newUpsDlg->getData(upsPref);
      // corrects data in list
      m_myUpsData->put(m_listBox2->currentItem(),upsPref);
      // corrects data in window
      m_listBox2->changeItem(upsPref.name,m_listBox2->currentItem());
      m_checked = true;
      // if active UPS is changed, will set checkedActiveUps
      // pokud zmenime aktivni UPS nastavime checkedActiveUps
      if ( m_activeUpsName == m_listBox2->currentText() ) m_checkedActiveUps = true;
      }
    delete newUpsDlg;
    }
  }


void KNutPrefDlg::slotNewUps () {
  upsRecord upsPref;
  // Zalozime novy zdroj
  // add new power
  newUpsDlg = new KNutNewUpsDlg(m_myUpsData,m_myAnalogData);
  int result = newUpsDlg->exec();
  if (result == Accepted) {
    // adds into list, when OK is pressed
    //reads data from form
    newUpsDlg->getData(upsPref);
    //pridame data do zaznamu
    //adds data to record
    m_myUpsData->add( upsPref);
    //add data to window
    // pridame data do okenka
    m_listBox2->insertItem(upsPref.name);
    // pokud pridame prvni prekreslime hlavni okno
    // when adds the first sameone, will repaint window
    m_checked = true;
    if (m_myUpsData->getCount() ==1 ) m_checkedActiveUps = true;
    }
  delete newUpsDlg;
  }


void KNutPrefDlg::slotOk() {
  slotApply ();
  accept();
  }

void KNutPrefDlg::slotApply() {
// budeme emitovat signal podle toho co se deje
// will emit signal about situation
  unsigned int changeSetting = 0;

 // MainPage
  if (m_prefData->countCols != m_numberOfColumns->value()) {
    changeSetting += ChangeCountCols;  // nastavime pocet sloupcu
    m_prefData->countCols = m_numberOfColumns->value();  // nastavime pocet sloupcu
    }

  if (m_prefData->customBColor != m_checkBoxCbc->isChecked()) {
    m_prefData->customBColor = m_checkBoxCbc->isChecked();
    changeSetting += ChangeCustomBColor;
    }
                           
  if (m_prefData->mainBackgroundColor != m_BGButton->color()) {
    changeSetting += ChangeMBColor;
    m_prefData->mainBackgroundColor = m_BGButton->color();  // nastavime barvu pozadi
    }
         
  // ovlivnuje jen ukonceni programu, neurcujeme type ChangeSetting
  if (m_prefData->areYouSure != m_checkBoxAys->isChecked()) {
    m_prefData->areYouSure = m_checkBoxAys->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }

  //for next start only
  if (m_prefData->useMainWindow != m_checkBoxMW->isChecked()) {
    m_prefData->useMainWindow = m_checkBoxMW->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }
  //for next start only
  if (m_prefData->useMessageWindow != m_checkBoxMesW->isChecked()) {
    m_prefData->useMessageWindow = m_checkBoxMesW->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }
    
      
  int newInputVoltage, newInputFrequency;
  if ( m_vRadioButton1->isChecked()) newInputVoltage = 230; else newInputVoltage = 120;
  if ( m_fRadioButton1->isChecked()) newInputFrequency = 50; else newInputFrequency = 60;

  if (m_prefData->inputVoltage != newInputVoltage) {
    m_prefData->inputVoltage = newInputVoltage;
    changeSetting += ChangeVoltage;
    }

  if (m_prefData->inputFrequency != newInputFrequency) {
    m_prefData->inputFrequency = newInputFrequency;
    changeSetting += ChangeFrequency;
    }

 if (m_prefData->lowHighXfer != m_xfer->isChecked()) changeSetting += ChangeXFer;
 m_prefData->lowHighXfer = m_xfer->isChecked();

    //Ups page
  if ( m_checkedActiveUps ) { // zmena aktivni UPS
    changeSetting += ChangeUpsSetting;
    }
  else {
    if (m_checked) changeSetting += ChangeUpsCount;
    }
  // panel Page
  unsigned int prefPanelFlags = 3;
  if (m_checkBoxOver->isChecked()) prefPanelFlags += KNutFrontPanel::PBOver;
  if (m_checkBoxBL->isChecked()) prefPanelFlags += KNutFrontPanel::PBBattLow;
  if (m_checkBoxRB->isChecked()) prefPanelFlags += KNutFrontPanel::PBRepBatt;
  if (m_checkBoxCal->isChecked()) prefPanelFlags += KNutFrontPanel::PBCal;
  if (m_checkBoxMFRM->isChecked()) prefPanelFlags += KNutFrontPanel::PBMFRMod;
  if (m_checkBoxMFR->isChecked()) prefPanelFlags += KNutFrontPanel::PBMFR;
  if (m_checkBoxModel->isChecked()) prefPanelFlags += KNutFrontPanel::PBModel;
  if (m_checkBoxSerial->isChecked()) prefPanelFlags += KNutFrontPanel::PBSerial;
  if (m_checkBoxFirm->isChecked()) prefPanelFlags += KNutFrontPanel::PBFirm;
  if (m_checkBoxRun->isChecked()) prefPanelFlags += KNutFrontPanel::PBRun;

  if (m_prefData->panelFlags != prefPanelFlags) {
    m_prefData->panelFlags = prefPanelFlags;
    changeSetting += ChangeMainPanelSetting;
    }

  if (m_prefData->customBPanelColor != m_checkBoxCbpc->isChecked()) {
    m_prefData->customBPanelColor = m_checkBoxCbpc->isChecked();
    changeSetting += ChangeCustomMPanelBColor;
    }

  if (m_prefData->mPanelBackgroundColor != m_BGPButton->color()) {
    changeSetting += ChangeMPBColor;
    m_prefData->mPanelBackgroundColor = m_BGPButton->color();  // sets color of background
    }


                          
    // font Page:
    unsigned int changeFonts;
    changeFonts =0;

    if (m_settingFont == MAIN_PANEL_FONT)
      m_mPanelFont=m_fontWidget->font();
    else
      m_aPanelFont=m_fontWidget->font();

    if ( m_customFont->isChecked() != m_prefData->customFont) {
      // zmena typy fontu systemove <-> uzivatelske
       m_prefData->customFont = m_customFont->isChecked();
       if (m_prefData->customFont) {
         // prejdeme na uzivatelske fonty
         m_prefData->aPanelFont = m_aPanelFont;
         m_prefData->mPanelFont = m_mPanelFont;
         changeSetting += ChangeAnalogFont;
         changeSetting += ChangePanelFont;
         }
       else {
         // pouzijeme systemove fonty
         changeSetting += ChangeAnalogFont;
         changeSetting += ChangePanelFont;
         }
      }
    else {
      if ( m_prefData->customFont ) {
        // otestujeme zda se zmenili nase fonty
        if (m_aPanelFont != m_prefData->aPanelFont) {
          m_prefData->aPanelFont = m_aPanelFont;
          changeSetting += ChangeAnalogFont;
          }
        if (m_mPanelFont != m_prefData->mPanelFont) {
          m_prefData->mPanelFont = m_mPanelFont;
          changeSetting += ChangePanelFont;
          }
        }
      }
  // analog page

  if (m_prefData->customBAnalogColor != m_checkBoxCbac->isChecked()) {
    m_prefData->customBAnalogColor = m_checkBoxCbac->isChecked();
    changeSetting += ChangeCustomAPanelBColor;
    }

  if (m_prefData->aPanelBackgroundColor != m_BGAButton->color()) {
    changeSetting += ChangeAPBColor;
    m_prefData->aPanelBackgroundColor = m_BGAButton->color();  // nastavime barvu pozadi
    }

  if (m_prefData->customOAnalogColor != m_checkBoxCoac->isChecked()) {
    m_prefData->customOAnalogColor = m_checkBoxCoac->isChecked();
    changeSetting += ChangeCustomAPanelOColor;
    }

  if ((m_prefData->analogFingerColor != m_AFingerButton->color()) ||
      (m_prefData->analogOKColor != m_AOKButton->color()) ||
      (m_prefData->analogWarnningColor != m_AWarnningButton->color()) ||
      (m_prefData->analogErrorColor != m_AErrorButton->color()) ||
      (m_prefData->analogScaleColor != m_AScaleButton->color()) ||
      (m_prefData->analogFontColor != m_AFontButton->color())) {
    changeSetting += ChangeAPOColor;
    m_prefData->analogFingerColor = m_AFingerButton->color();  // nastavime barvu rucicky
    m_prefData->analogOKColor = m_AOKButton->color();  // nastavime barvu ok
    m_prefData->analogWarnningColor = m_AWarnningButton->color();  // nastavime barvu varovano
    m_prefData->analogErrorColor = m_AErrorButton->color();  // nastavime barvu chyby
    m_prefData->analogScaleColor = m_AScaleButton->color();  // nastavime barvu stupnice
    m_prefData->analogFontColor = m_AFontButton->color();  // nastavime barvu textu
    }
    
  // Kicker Icon page

  int stateKIcon;
  if (m_iconRadioButton1->isChecked()) stateKIcon = KNutDock::pictureKI;
  else stateKIcon = KNutDock::generalKI;
  if (m_prefData->typeOfKIcon != stateKIcon) {
    if (m_iconRadioButton1->isChecked()) m_prefData->typeOfKIcon = KNutDock::pictureKI;
    if (m_iconRadioButton2->isChecked()) m_prefData->typeOfKIcon = KNutDock::generalKI;
    changeSetting += ChangeTypeOfKIcon;
    }

  if (m_prefData->customKIconColor != m_checkBoxCbi->isChecked()) {
    m_prefData->customKIconColor = m_checkBoxCbi->isChecked();
    changeSetting += ChangeCustomKIconColor;
    }

  if (m_prefData->kIconBackgroundColor != m_BGIButton->color()) {
    changeSetting += ChangeKIconBColor;
    m_prefData->kIconBackgroundColor = m_BGIButton->color();  // nastavime barvu pozadi
    }

  unsigned int prefToolTipFlags = 0;
  if (m_checkBoxTTMFR->isChecked()) prefToolTipFlags += KNutDock::TTMFR;
  if (m_checkBoxTTModel->isChecked()) prefToolTipFlags += KNutDock::TTModel;
  if (m_checkBoxTTSerial->isChecked()) prefToolTipFlags += KNutDock::TTSerial;
  if (m_checkBoxTTFirm->isChecked()) prefToolTipFlags += KNutDock::TTFirm;
  if (m_checkBoxTTRun->isChecked()) prefToolTipFlags += KNutDock::TTRun;
  if (m_checkBoxTTCharge->isChecked()) prefToolTipFlags += KNutDock::TTCharge;
  if (m_checkBoxTTLoad->isChecked()) prefToolTipFlags += KNutDock::TTLoad;

  if (m_prefData->toolTipFlags != prefToolTipFlags) {
    m_prefData->toolTipFlags = prefToolTipFlags;
    changeSetting += ChangeToolTip;
    }
            
  if (changeSetting)  emit signalChangeConfig( changeSetting );
  }


void KNutPrefDlg::slotDefault() {
  switch (activePageIndex()) {
    case mainSettingPage:
      m_numberOfColumns->setValue( knc::DefaultCountCols );
      m_BGButton->setColor(DEFAULT_BG_COLOR);
      m_checkBoxAys->setChecked ( false );
      m_checkBoxMW->setChecked ( true );
      m_checkBoxMesW->setChecked ( false );
      m_vRadioButton1->setChecked( true );
      m_fRadioButton1->setChecked( true );
      m_xfer->setChecked( false );
      break;
    case panelSettingPage:
      m_checkBoxOver->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBOver);
      m_checkBoxBL->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBBattLow);
      m_checkBoxRB->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBRepBatt);
      m_checkBoxCal->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBCal);
      m_checkBoxMFRM->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBMFRMod);
      m_checkBoxMFR->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBMFR);
      m_checkBoxModel->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBModel);
      m_checkBoxSerial->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBSerial);
      m_checkBoxFirm->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBFirm);
      m_checkBoxCbpc->setChecked(false);
      m_BGAButton->setColor(DEFAULT_BG_COLOR);
      break;
   case fontSettingPage:
      m_customFont->setChecked(false);
      break;
   case analogSettingPage:
      m_checkBoxCbac->setChecked(false);
      m_BGAButton->setColor(DEFAULT_BG_COLOR);
      m_checkBoxCoac->setChecked(false);
      m_AFingerButton->setColor(DEFAULT_FINGER_COLOR);
      m_AOKButton->setColor(DEFAULT_OK_COLOR);
      m_AWarnningButton->setColor(DEFAULT_WARNNING_COLOR);
      m_AErrorButton->setColor(DEFAULT_ERROR_COLOR);
      m_AScaleButton->setColor(DEFAULT_SCALE_COLOR);
      m_AFontButton->setColor(DEFAULT_FONT_COLOR);
      break;
   case kickerSettingPage:
      m_checkBoxCbi->setChecked(false);
      m_BGAButton->setColor(DEFAULT_KICON_COLOR);
      m_checkBoxTTMFR->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTMFR);
      m_checkBoxTTModel->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTModel);
      m_checkBoxTTSerial->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTSerial);
      m_checkBoxTTFirm->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTFirm);
      m_checkBoxTTRun->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTRun);
      m_checkBoxTTCharge->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTCharge);
      m_checkBoxTTLoad->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTLoad);
      m_iconRadioButton1->setChecked( true );
      break;
    }
  }

/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/

void KNutPrefDlg::initSetting () {
  QFrame *page = addPage( i18n("Setting"),i18n("Main Setting"),DesktopIcon("misc"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );

  QGroupBox *dataBox = new QGroupBox (page ,"dataBox");
  QGridLayout *dataLayout = new QGridLayout (dataBox,5,2,spacingHint());
  dataBox->setFrameStyle(QFrame::NoFrame);
  setTopLayout->addWidget(dataBox);

  QButtonGroup *VFGroup = new QButtonGroup(i18n("Voltage/Frequency"),page,"VFGroup");
  QGridLayout *setVoltFreqLayout = new QGridLayout (VFGroup, 4 , 2,spacingHint () );

  m_xfer = new QCheckBox (i18n("&Use High-Low XFER"),VFGroup,"m_xfer");

  QLabel *initSettingLabel1 = new QLabel(i18n("Number of columns :"),dataBox,"label1");
  m_numberOfColumns = new QSpinBox(knc::MinCols,knc::MaxCols,1,dataBox);

  QLabel *initSettingLabel2 = new QLabel(i18n("Use custom background color"),dataBox,"label2");
  m_checkBoxCbc = new QCheckBox ("",dataBox,"checboxcbc");

  
  m_mainBackgroundColorLabel = new QLabel(i18n("Color of background :"),dataBox,"label3");
  m_BGButton = new KColorButton (dataBox);
  m_BGButton->setColor (m_prefData->mainBackgroundColor);

  QLabel *initSettingLabel4 = new QLabel(i18n("Use dialog \"Are you sure\""),dataBox,"m_areYouSureLabel");
  m_checkBoxAys = new QCheckBox ("",dataBox,"checboxays");

  QLabel *initSettingLabel5 = new QLabel(i18n("Use Main window when program is started"),dataBox,"initSettingLabel5");
  m_checkBoxMW = new QCheckBox ("",dataBox,"checboxmv");
  
  QLabel *initSettingLabel6 = new QLabel(i18n("Show message window, when program reports error"),dataBox,"initSettingLabel6");
  m_checkBoxMesW = new QCheckBox ("",dataBox,"checboxer");
  
  
  

  m_voltageGroup = new QButtonGroup(i18n("Nominal Input Voltage"),VFGroup,"voltageGroup");
  QGridLayout *voltLayout = new QGridLayout (m_voltageGroup, 3 , 1,spacingHint () );

  m_vRadioButton1 = new QRadioButton(i18n("&230 V"), m_voltageGroup, "vRadioButton1" );
  m_vRadioButton2 = new QRadioButton(i18n("&120 V"), m_voltageGroup, "vRadioButton2" );

  m_frequencyGroup = new QButtonGroup(i18n("Nominal Input Frequency"),VFGroup,"frequencyGroup");
  QGridLayout *freqLayout = new QGridLayout (m_frequencyGroup, 3 , 1,spacingHint () );

  m_fRadioButton1 = new QRadioButton(i18n("&50 Hz"), m_frequencyGroup, "fRadioButton1" );
  m_fRadioButton2 = new QRadioButton(i18n("&60 Hz"), m_frequencyGroup, "fRadioButton2" );

  dataLayout->addWidget (initSettingLabel1,0,0);
  dataLayout->addWidget (m_numberOfColumns,0,1);

  dataLayout->addWidget (initSettingLabel2,1,0);
  dataLayout->addWidget (m_checkBoxCbc,1,1);

  dataLayout->addWidget (m_mainBackgroundColorLabel,2,0);
  dataLayout->addWidget (m_BGButton,2,1);

  dataLayout->addWidget (initSettingLabel4,3,0);
  dataLayout->addWidget (m_checkBoxAys,3,1);
  
  dataLayout->addWidget (initSettingLabel5,4,0);
  dataLayout->addWidget (m_checkBoxMW,4,1);

  dataLayout->addWidget (initSettingLabel6,5,0);
  dataLayout->addWidget (m_checkBoxMesW,5,1);

  dataLayout->setColStretch(1,5);

  voltLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  voltLayout->addWidget ( m_vRadioButton1,1,0 );
  voltLayout->addWidget ( m_vRadioButton2,2,0 );

  freqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  freqLayout->addWidget ( m_fRadioButton1,1,0 );
  freqLayout->addWidget ( m_fRadioButton2,2,0 );

  setTopLayout->addWidget (VFGroup,10);
  setVoltFreqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  setVoltFreqLayout->addWidget ( m_voltageGroup,1,0 );
  setVoltFreqLayout->addWidget ( m_frequencyGroup,1,1 );
  setVoltFreqLayout->addWidget ( m_xfer,2,0 );
  setVoltFreqLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  setTopLayout->addStretch( 20 );

  //sets value
  m_numberOfColumns->setValue(m_prefData->countCols);
  m_BGButton->setColor(m_prefData->mainBackgroundColor);  // sets color of backgound
  m_checkBoxAys->setChecked(m_prefData->areYouSure);
  m_checkBoxMW->setChecked(m_prefData->useMainWindow);
  m_checkBoxMesW->setChecked(m_prefData->useMessageWindow);

  if (m_prefData->inputVoltage == 230)
    m_vRadioButton1->setChecked( true );
  else
    m_vRadioButton2->setChecked( true );
  if (m_prefData->inputFrequency == 50)
    m_fRadioButton1->setChecked( true );
  else
   m_fRadioButton2->setChecked( true );

  m_xfer->setChecked(m_prefData->lowHighXfer);
  m_voltageGroup->setEnabled(!m_prefData->lowHighXfer);
  m_frequencyGroup->setEnabled(!m_prefData->lowHighXfer);
  connect (m_xfer,SIGNAL(toggled(bool)),this,SLOT(slotEnableVoltage(bool)));
  connect (m_xfer,SIGNAL(toggled(bool)),this,SLOT(slotEnableFrequency(bool)));

  
  m_checkBoxCbc->setChecked(m_prefData->customBColor); 
  m_BGButton->setColor(m_prefData->mainBackgroundColor);
  m_BGButton->setEnabled(m_prefData->customBColor);
  m_mainBackgroundColorLabel->setEnabled(m_prefData->customBColor);
  connect (m_checkBoxCbc,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBColor(bool)));
  }

void KNutPrefDlg::initUps () {
  QFrame *page = addPage( i18n("UPS"),i18n("UPS Setting"),DesktopIcon("knutclient"));
  QHBoxLayout *upsTopLayout = new QHBoxLayout( page, 0, spacingHint (),"upsTopLayout" );

  // makes box for names of UPS's / Vytvorime box pro jmena UPS-ek
  m_listBox2 = new KListBox( page, "ListBox2" );
  m_listBox2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, m_listBox2->sizePolicy().hasHeightForWidth() ) );
  m_listBox2->setFrameShape( QListBox::StyledPanel );
  m_listBox2->setFrameShadow( QListBox::Sunken );
  m_listBox2->setMinimumSize (100,100);

  // sets listbox
  for (int i=0; i < m_myUpsData->getCount (); i++) m_listBox2->insertItem (m_myUpsData->getName(i));
  //includes listbox into horizontal layout on the first place
  upsTopLayout->addWidget( m_listBox2, 20 );
  // makes vertical layout and includes it in horizontal layout into the second place 
  QVBoxLayout *upsLayout = new QVBoxLayout( upsTopLayout, spacingHint (),"upsLayout" );

  // vytvorime tlacitka
  KPushButton *newButton = new KPushButton (i18n("&Add"),page);
  KPushButton *editButton = new KPushButton (i18n("&Edit"),page);
  KPushButton *deleteButton = new KPushButton (i18n("&Delete"),page);

  // includes buttons into layout /  vlozime tlacitka do layoutu
  upsLayout->addWidget( newButton );
  upsLayout->addWidget( editButton );
  upsLayout->addWidget( deleteButton );

  upsLayout->addStretch( 10 );

  connect (newButton,SIGNAL(clicked()),this,SLOT(slotNewUps()));
  connect (editButton,SIGNAL(clicked()),this,SLOT(slotEditUps()));
  connect (deleteButton,SIGNAL(clicked()),this,SLOT(slotDeleteUps()));
  connect (m_listBox2,SIGNAL(doubleClicked(QListBoxItem*, const QPoint&)),this,SLOT(slotEditUps()));
  
  }

void KNutPrefDlg::initDock () {
//  QFrame *page = addPage( i18n("Dock"),i18n("Docking Setting"),DesktopIcon("knutclient"));
  QFrame *page = addPage( i18n("Dock"),i18n("Docking Setting"),DesktopIcon("kcmkicker"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );

  QButtonGroup *typeGroup = new QButtonGroup(i18n("Type of dock's showing"),page,"typeGroup");
  QGridLayout *typeLayout = new QGridLayout (typeGroup,2,2,spacingHint());
  setTopLayout->addWidget(typeGroup);


  QGroupBox *infoBox = new QGroupBox (i18n("Items of tooltip"),page ,"infoBox");
  QGridLayout *infoLayout = new QGridLayout (infoBox,8,1,spacingHint());
  setTopLayout->addWidget(infoBox);

  QGridLayout *colorLayout = new QGridLayout (10,1,spacingHint(),"colorLayout");
  setTopLayout->addLayout(colorLayout);


  m_iconRadioButton1 = new QRadioButton(i18n("&Picture"), typeGroup, "iconRadioButton1" );
  m_iconRadioButton2 = new QRadioButton(i18n("&General"), typeGroup, "iconRadioButton2" );

  
  m_checkBoxTTMFR = new QCheckBox (i18n("M&anufacturer"),infoBox);
  m_checkBoxTTMFR->setChecked((m_prefData->toolTipFlags) & KNutDock::TTMFR);

  m_checkBoxTTModel = new QCheckBox (i18n("M&odel"),infoBox);
  m_checkBoxTTModel->setChecked((m_prefData->toolTipFlags) & KNutDock::TTModel);

  m_checkBoxTTSerial = new QCheckBox (i18n("&Serial"),infoBox);
  m_checkBoxTTSerial->setChecked((m_prefData->toolTipFlags) & KNutDock::TTSerial);

  m_checkBoxTTFirm = new QCheckBox (i18n("&Firm. rev."),infoBox);
  m_checkBoxTTFirm->setChecked((m_prefData->toolTipFlags) & KNutDock::TTFirm);

  m_checkBoxTTRun = new QCheckBox (i18n("&Runtime"),infoBox);
  m_checkBoxTTRun->setChecked((m_prefData->toolTipFlags) & KNutDock::TTRun);

  m_checkBoxTTCharge = new QCheckBox (i18n("&Battery Charge"),infoBox);
  m_checkBoxTTCharge->setChecked((m_prefData->toolTipFlags) & KNutDock::TTCharge);

  m_checkBoxTTLoad = new QCheckBox (i18n("&UPS Load"),infoBox);
  m_checkBoxTTLoad->setChecked((m_prefData->toolTipFlags) & KNutDock::TTLoad);
  
  
  QLabel *initDockLabel1 = new QLabel(i18n("Use custom icon's background color"),page,"label1");
  m_checkBoxCbi = new QCheckBox ("",page,"checboxcbpc");

  m_dockBackgroundColorLabel = new QLabel(i18n("Color of icon's background :"),page,"label12");
  m_BGIButton = new KColorButton (page);

  typeLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  typeLayout->addWidget ( m_iconRadioButton1,1,0 );
  typeLayout->addWidget ( m_iconRadioButton2,2,0 );

  if (m_prefData->typeOfKIcon == KNutDock::pictureKI)
    m_iconRadioButton1->setChecked( true );
  if (m_prefData->typeOfKIcon == KNutDock::generalKI)
    m_iconRadioButton2->setChecked( true );
  
  infoLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  infoLayout->addWidget ( m_checkBoxTTMFR ,1,0);
  infoLayout->addWidget ( m_checkBoxTTModel ,2,0);
  infoLayout->addWidget ( m_checkBoxTTSerial ,3,0);
  infoLayout->addWidget ( m_checkBoxTTFirm ,4,0);
  infoLayout->addWidget ( m_checkBoxTTRun ,5,0);
  infoLayout->addWidget ( m_checkBoxTTCharge ,6,0);
  infoLayout->addWidget ( m_checkBoxTTLoad ,7,0);
  
  colorLayout->addWidget (initDockLabel1,0,0);
  colorLayout->addWidget (m_checkBoxCbi,0,1);
  colorLayout->addWidget (m_dockBackgroundColorLabel,1,0);
  colorLayout->addWidget (m_BGIButton,1,1);

  m_checkBoxCbi->setChecked(m_prefData->customKIconColor);
  m_BGIButton->setColor(m_prefData->kIconBackgroundColor);
  m_BGIButton->setEnabled(m_prefData->customKIconColor);
  m_dockBackgroundColorLabel->setEnabled(m_prefData->customKIconColor);

  
  setTopLayout->addStretch( 20 );

  connect (m_checkBoxCbi,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBIconColor(bool)));
  }
  

void KNutPrefDlg::initPanel () {
  QFrame *page = addPage( i18n("Panel"),i18n("Panel Setting"),DesktopIcon("panel_settings"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );


  QGroupBox *infoBox = new QGroupBox (page ,"infoBox");
  QGridLayout *infoLayout = new QGridLayout (infoBox,10,1,spacingHint());
  setTopLayout->addWidget(infoBox);

  QGridLayout *colorLayout = new QGridLayout (10,1,spacingHint(),"colorLayout");
  setTopLayout->addLayout(colorLayout);
  

  // vytvorime widgety - Nazev Zatrhavaci box
  //makes widgets - name checkbox
  m_checkBoxOver = new QCheckBox (i18n("UPS &Overload"),infoBox);
  m_checkBoxOver->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBOver);

  m_checkBoxBL = new QCheckBox (i18n("UPS &Battery low"),infoBox);
  m_checkBoxBL->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBBattLow);

  m_checkBoxRB = new QCheckBox (i18n("R&eplace battery"),infoBox);
  m_checkBoxRB->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBRepBatt);

  m_checkBoxCal = new QCheckBox (i18n("Ups &calibration"),infoBox);
  m_checkBoxCal->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBCal);

  m_checkBoxMFRM = new QCheckBox (i18n("&Manufac. + Model"),infoBox);
  m_checkBoxMFRM->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBMFRMod);

  m_checkBoxMFR = new QCheckBox (i18n("M&anufacturer"),infoBox);
  m_checkBoxMFR->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBMFR);

  m_checkBoxModel = new QCheckBox (i18n("M&odel"),infoBox);
  m_checkBoxModel->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBModel);

  m_checkBoxSerial = new QCheckBox (i18n("&Serial"),infoBox);
  m_checkBoxSerial->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBSerial);

  m_checkBoxFirm = new QCheckBox (i18n("&Firm. rev."),infoBox);
  m_checkBoxFirm->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBFirm);

  m_checkBoxRun = new QCheckBox (i18n("&Runtime"),infoBox);
  m_checkBoxRun->setChecked((m_prefData->panelFlags) & KNutFrontPanel::PBRun);


  QLabel *initPanelLabel1 = new QLabel(i18n("Use custom background color"),page,"label1");
  m_checkBoxCbpc = new QCheckBox ("",page,"checboxcbpc");

  m_panelBackgroundColorLabel = new QLabel(i18n("Color of background :"),page,"m_panelBackgroundColorLabel");
  m_BGPButton = new KColorButton (page);

  // includes widgets
  infoLayout->addWidget ( m_checkBoxOver, 0,0);
  infoLayout->addWidget ( m_checkBoxBL ,1,0);
  infoLayout->addWidget ( m_checkBoxRB ,2,0);
  infoLayout->addWidget ( m_checkBoxCal ,3,0);
  infoLayout->addWidget ( m_checkBoxMFRM ,4,0);
  infoLayout->addWidget ( m_checkBoxMFR ,5,0);
  infoLayout->addWidget ( m_checkBoxModel ,6,0);
  infoLayout->addWidget ( m_checkBoxSerial ,7,0);
  infoLayout->addWidget ( m_checkBoxFirm ,8,0);
  infoLayout->addWidget ( m_checkBoxRun ,9,0);

  colorLayout->addWidget (initPanelLabel1,0,0);
  colorLayout->addWidget (m_checkBoxCbpc,0,1);
  colorLayout->addWidget (m_panelBackgroundColorLabel,1,0);
  colorLayout->addWidget (m_BGPButton,1,1);

  setTopLayout->addStretch( 20 );

  m_checkBoxCbpc->setChecked(m_prefData->customBPanelColor);
  m_BGPButton->setColor(m_prefData->mPanelBackgroundColor);
  m_BGPButton->setEnabled(m_prefData->customBPanelColor);
  m_panelBackgroundColorLabel->setEnabled(m_prefData->customBPanelColor);
  m_panelBackgroundColorLabel->setEnabled(m_prefData->customBPanelColor);
  connect (m_checkBoxCbpc,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBPanelColor(bool)));

  }


void KNutPrefDlg::initFonts () {
  QFrame *page = addPage( i18n("Fonts"),i18n("Setting Fonts"),DesktopIcon("fonts"));

  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  QHBoxLayout *setSysLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  QHBoxLayout *setTypeLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  QHBoxLayout *setFontLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setFontLayout" );

  m_customFont = new QCheckBox (i18n("&Use custom font"),page);
  setSysLayout->addWidget ( m_customFont ,10);
  setSysLayout->addStretch( 10 );

  KComboBox *panelFonts = new KComboBox(page);
  panelFonts->insertItem (i18n("Main panel"));
  panelFonts->insertItem (i18n("Analog panels"));
  setTypeLayout->addWidget ( panelFonts ,0);



  m_fontWidget = new KFontChooser(page,"Font",false);
  setFontLayout->addWidget (m_fontWidget ,0);

  setTopLayout->addStretch( 20 );

// init items
  m_customFont->setChecked(m_prefData->customFont);
  m_aPanelFont = m_prefData->aPanelFont;
  m_mPanelFont = m_prefData->mPanelFont;
  m_settingFont = MAIN_PANEL_FONT; // sets font for Main Panel /  nastavujeme font pro Main Panel
  m_fontWidget->setFont(m_mPanelFont);
  m_fontWidget->setEnabled(m_prefData->customFont);
  connect (panelFonts,SIGNAL(activated(int)),this,SLOT(slotChangeSettingFont(int)));
  connect (m_customFont,SIGNAL(toggled(bool)),m_fontWidget,SLOT(setEnabled(bool)));
  }

void KNutPrefDlg::initAnalog () {
  QFrame *page = addPage( i18n("Analog"),i18n("Setting Analog panel"),DesktopIcon("ksysguard"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  QGridLayout *setColorLayout = new QGridLayout( 8,2, spacingHint(),"setColorLayout");
  setTopLayout->addLayout(setColorLayout);
  setTopLayout->addStretch( 20 );

  QLabel *initAnalogLabel1 = new QLabel(i18n("Use custom background color"),page,"initAnalogLabel1");
  m_checkBoxCbac = new QCheckBox ("",page,"checboxcbac");
  m_analogBackgroundColorLabel = new QLabel(i18n("Color of background :"),page,"m_backgroundColorLabel");
  m_BGAButton = new KColorButton (page);
  QLabel *initAnalogLabel12 = new QLabel(i18n("Use custom other colors"),page,"label12");
  m_checkBoxCoac = new QCheckBox ("",page,"checboxcoac");
  m_analogPointerColorLabel = new QLabel(i18n("Color of pointer :"),page,"m_analogPointerColorLabel");
  m_AFingerButton = new KColorButton (page);
  m_analogOKColorLabel = new QLabel(i18n("Color of OK range :"),page,"label7");
  m_AOKButton = new KColorButton (page);
  m_analogWarningColorLabel = new QLabel(i18n("Color of warning range :"),page,"label8");
  m_AWarnningButton = new KColorButton (page);
  m_analogErrorColorLabel= new QLabel(i18n("Color of error range :"),page,"label9");
  m_AErrorButton = new KColorButton (page);
  m_analogScaleColorLabel = new QLabel(i18n("Color of scale :"),page,"label10");
  m_AScaleButton = new KColorButton (page);
  m_analogFontColorLabel = new QLabel(i18n("Color of font :"),page,"label11");
  m_AFontButton = new KColorButton (page);


  setColorLayout->addWidget ( initAnalogLabel1, 0,0);
  setColorLayout->addWidget ( m_checkBoxCbac ,0,1);
  setColorLayout->addWidget ( m_analogBackgroundColorLabel, 1,0);
  setColorLayout->addWidget ( m_BGAButton ,1,1);
  setColorLayout->addWidget ( initAnalogLabel12, 2,0);
  setColorLayout->addWidget ( m_checkBoxCoac ,2,1);
  setColorLayout->addWidget ( m_analogPointerColorLabel, 3,0);
  setColorLayout->addWidget ( m_AFingerButton ,3,1);
  setColorLayout->addWidget ( m_analogOKColorLabel, 4,0);
  setColorLayout->addWidget ( m_AOKButton ,4,1);
  setColorLayout->addWidget ( m_analogWarningColorLabel, 5,0);
  setColorLayout->addWidget ( m_AWarnningButton ,5,1);
  setColorLayout->addWidget ( m_analogErrorColorLabel, 6,0);
  setColorLayout->addWidget ( m_AErrorButton ,6,1);
  setColorLayout->addWidget ( m_analogScaleColorLabel, 7,0);
  setColorLayout->addWidget ( m_AScaleButton ,7,1);
  setColorLayout->addWidget ( m_analogFontColorLabel, 8,0);
  setColorLayout->addWidget ( m_AFontButton ,8,1);


  m_checkBoxCbac->setChecked(m_prefData->customBAnalogColor);
  m_checkBoxCoac->setChecked(m_prefData->customOAnalogColor);
  m_BGAButton->setColor(m_prefData->aPanelBackgroundColor);
  m_BGAButton->setEnabled(m_prefData->customBAnalogColor);
  m_AFingerButton->setColor(m_prefData->analogFingerColor);
  m_AFingerButton->setEnabled(m_prefData->customOAnalogColor);
  m_AOKButton->setColor(m_prefData->analogOKColor);
  m_AOKButton->setEnabled(m_prefData->customOAnalogColor);
  m_AWarnningButton->setColor(m_prefData->analogWarnningColor);
  m_AWarnningButton->setEnabled(m_prefData->customOAnalogColor);
  m_AErrorButton->setColor(m_prefData->analogErrorColor);
  m_AErrorButton->setEnabled(m_prefData->customOAnalogColor);
  m_AScaleButton->setColor(m_prefData->analogScaleColor);
  m_AScaleButton->setEnabled(m_prefData->customOAnalogColor);
  m_AFontButton->setColor(m_prefData->analogFontColor);
  m_AFontButton->setEnabled(m_prefData->customOAnalogColor);
  m_analogBackgroundColorLabel->setEnabled(m_prefData->customBAnalogColor);
  m_analogPointerColorLabel->setEnabled(m_prefData->customOAnalogColor);
  m_analogOKColorLabel->setEnabled(m_prefData->customOAnalogColor);
  m_analogWarningColorLabel->setEnabled(m_prefData->customOAnalogColor);
  m_analogErrorColorLabel->setEnabled(m_prefData->customOAnalogColor);
  m_analogScaleColorLabel->setEnabled(m_prefData->customOAnalogColor);
  m_analogFontColorLabel->setEnabled(m_prefData->customOAnalogColor);

  connect (m_checkBoxCbac,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBAnalogColor(bool)));
  connect (m_checkBoxCoac,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomOAnalogColor(bool)));
  }
  
  
  
#include "knutprefdlg.moc"
