/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "specificcolorselector_dock.h"

#include <kis_layer.h>
#include <kis_view2.h>

#include <QLabel>

#include <kis_resource_provider.h>

#include "kis_specific_color_selector_widget.h"

SpecificColorSelectorDock::SpecificColorSelectorDock( KisView2 *view ) : QDockWidget(i18n("Specific Color Selector")), m_view(view)
{
    m_colorSelector = new KisSpecificColorSelectorWidget(this);
    setWidget( m_colorSelector );
    connect( m_colorSelector, SIGNAL(colorChanged(const KoColor&)), view->resourceProvider(), SLOT(slotSetFGColor(const KoColor&)));
    connect( view->resourceProvider(), SIGNAL(sigFGColorChanged(const KoColor&)), m_colorSelector, SLOT(setColor(const KoColor&)));
    m_colorSelector->setColor( view->resourceProvider()->fgColor() );
    connect( view->resourceProvider(), SIGNAL(sigLayerChanged(const KisLayerSP)), this, SLOT(layerChanged(const KisLayerSP)));
}

void SpecificColorSelectorDock::layerChanged(const KisLayerSP l)
{
    m_colorSelector->setColorSpace( l->colorSpace());
}


#include "specificcolorselector_dock.moc"
