/***************************************************************************
             mreportviewer.h  -  Kugar QT report viewer widget
             -------------------
   begin     : Fri Aug 13 1999
   copyright : (C) 1999 by Mutiny Bay Software
   email     : info@mutinybaysoftware.com
   copyright : (C) 2002 Alexander Dymo
   email     : cloudtemple@mksat.net
***************************************************************************/

#ifndef MREPORTVIEWER_H
#define MREPORTVIEWER_H

#include <qapplication.h>
#include <QWidget>
#include <q3scrollview.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <q3paintdevicemetrics.h>
#include <qprogressdialog.h>
#include <qpointer.h>
//Added by qt3to4:
#include <QResizeEvent>
#include <QPaintEvent>
#include <kugarlib_export.h>
#include "mreportengine.h"
#include "mpagecollection.h"
#include "mpagedisplay.h"

#define M_PROGRESS_DELAY 500            // Number of ms to delay progress dialog display

class QPrinter;

/** Application reference, required for event processing */
extern QApplication *mAppRef;

/**Kugar QT report viewer widget
  *@author Mutiny Bay Software
  */

namespace Kugar
{

class KUGARLIB_EXPORT MReportViewer : public QWidget
{
    Q_OBJECT

public:
    MReportViewer( QWidget *parent = 0, const char *name = 0 );
    MReportViewer( MReportEngine* engine, QWidget *parent = 0, const char *name = 0 );
    virtual ~MReportViewer();

    bool setReportData( const QString & );
    bool setReportData( QIODevice * );
    bool setReportTemplate( const QString & );
    bool setReportTemplate( QIODevice * );
    bool renderReport();
    void clearReport();
    void printReport();
    void printReport( QPrinter &printer, QPrintDialog &printDialog );
    void setupPrinter( QPrinter &printer, QPrintDialog &printDialog );
    void printReportSilent( int printFrom = -1, int printTo = -1, int printCopies = -1, QString printerName = QString::null );

    QSize sizeHint() const;

public slots:
    void slotFirstPage();
    void slotNextPage();
    void slotPrevPage();
    void slotLastPage();

signals:
    void preferedTemplate( const QString & );

private slots:
    void slotCancelPrinting();
    void slotRenderProgress( int );

protected:
    void paintEvent( QPaintEvent *event );
    void resizeEvent( QResizeEvent *event );

    Q3ScrollView *scroller;
    MPageDisplay *display;
    MReportEngine *rptEngine;
    QPointer<MPageCollection> report;
    QPrinter *printer;

private:
    QProgressDialog* progress;
    int totalSteps;
    void init();
};

}

#endif
