/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qwidget.h>
#include <qtextedit.h>

#include <kdialogbase.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include "kompileprofiledialog.h"
#include "kompileprofilewidget.h"

KompileProfileDialog::KompileProfileDialog(QWidget *parent, const char *name)
    :KDialogBase(parent, name, TRUE, i18n("Profile Setup"), KDialogBase::User1|KDialogBase::User2|KDialogBase::Cancel, KDialogBase::User2, TRUE, i18n("Save Profile"), i18n("Load Profile"))
{
  widget = new KompileProfileWidget( this );
  setMainWidget(widget);

  connect(this, SIGNAL(user1Clicked()), this, SLOT(saveAndUseProfile()));
  connect(this, SIGNAL(user2Clicked()), this, SLOT(loadProfile()));

  this->profile = NULL;
  this->profile_name = QString();
}

KompileProfileDialog::KompileProfileDialog(QString& profile, QWidget *parent, const char *name)
    :KDialogBase(parent, name, TRUE, i18n("Profile Setup"), KDialogBase::User1|KDialogBase::User2|KDialogBase::Cancel, KDialogBase::Apply, TRUE, i18n("Save and use profile"), i18n("Load saved profile"))
{
  widget = new KompileProfileWidget( this );
  setMainWidget(widget);
  widget->loadProfile(profile);

  connect(this, SIGNAL(user1Clicked()), this, SLOT(saveAndUseProfile()));
  connect(this, SIGNAL(user2Clicked()), this, SLOT(loadProfile()));

  this->profile = NULL;
  this->profile_name = QString();
}


KompileProfileDialog::~KompileProfileDialog()
{}

void KompileProfileDialog::saveAndUseProfile()
{
  if (!widget->saveProfile())
    return;
  profile = widget->getProfile();
  profile_name = widget->getProfileFile();
  this->close();
}

KConfig * KompileProfileDialog::getDefaultProfile()
{
  return new KConfig(locateLocal("appdata", "") + "/default-profile.komprof");
}


void KompileProfileDialog::loadProfile()
{
  widget->loadProfile();
}

KConfig * KompileProfileDialog::getProfile()
{
  return profile;
}

QString KompileProfileDialog::getProfileFile()
{
  return profile_name;
}
#include "kompileprofiledialog.moc"
