//
// C++ Implementation: apppropprg
//
// Description: 
//
//
// Author: KoolDock team <radix@kde.cl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <kicondialog.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include "apppropprg.h"
#include "appProp.h"
#include "kooldock.h"

appPropPrg::appPropPrg(QWidget *parent, const char *name)
: appProp(parent, name)
{
   appRestart->setChecked(false);
}


appPropPrg::~appPropPrg()
{
}

void appPropPrg::accept()
{
   QString icon;
   QString desktop;
   QString path;
   QString puser;
	
   icon=iconbutton->icon();
   desktop=cmdname->text();
   path=cmdpath->text();
   puser=user->text();
	
   if(icon.length() == 0)
   {
      KMessageBox::sorry(0, i18n("You must select an icon!"), i18n("Error"), 1);
      return;
   }
   if(desktop.length() == 0)
   {
      KMessageBox::sorry(0, i18n("You must enter a name!"), i18n("Error"), 1);
      return;
   }
   if(path.length() == 0)
   {
      KMessageBox::sorry(0, i18n("You must enter a command or path!"), i18n("Error"), 1);
      return;
   }
   if((cuser->isChecked()==true) && (puser.length()==0))
   {
      KMessageBox::sorry(0, i18n("You must provide a username!"), i18n("Error"), 1);
      return;
   }


   // Now we modify desktop (lowercase, no spaces)
   desktop.remove(" ", TRUE);
   desktop=desktop.lower();
   desktop.append(".desktop");
   
   //To handle position
   QString progPath = locateLocal("data", "kooldock");
   QDir dir(progPath + QString("/menu/"));
   QString preffix;
   QStringList fileList = dir.entryList("*.desktop");
   
   int pos=fileList.count();
   if(pos<10) preffix=QString("0%1_").arg(pos);
   if(pos>=10) preffix=QString("%1_").arg(pos);
   
   desktop.prepend(preffix);
   //End handling position   
   
   /* Here we add the .desktop file to the menuPath */
   KoolDock::addFile(desktop, icon, cmdpath->text(), cmdname->text(), true, terminal->isChecked(), tclose->isChecked(), cuser->isChecked(), user->text());
   appRestart->setChecked(true);
   user->setEnabled(false);
   cuser->setChecked(false);
   terminal->setChecked(false);
   tclose->setChecked(false);
   tclose->setEnabled(false);
   this->hide();
}

void appPropPrg::reject()
{
   appRestart->setChecked(FALSE);
   user->setEnabled(false);
   cuser->setChecked(false);
   terminal->setChecked(false);
   tclose->setChecked(false);
   tclose->setEnabled(false);
   this->hide();
}

void appPropPrg::closeEvent( QCloseEvent *e )
{
   e->ignore();
   reject();
}

void appPropPrg::cmdfile_clicked()
{
   QString tmp;

   QString fileToOpen=KFileDialog::getOpenFileName(QDir::currentDirPath(), "*.*", this, i18n("Open File"));
   if (!fileToOpen.isEmpty())
   {
      cmdpath->setText(fileToOpen);

      //Lets set a default icon based on the program name
      tmp=fileToOpen;
      int pos=tmp.findRev("/", -1);
      if(pos!=-1)
      {
         tmp.remove(1, pos);
         tmp.remove("/", TRUE);
      }
      iconbutton->setIcon(tmp);
      cmdname->setText(tmp);
   }
}

void appPropPrg::cuserchk()
{
   if(cuser->isChecked()==true)
   {
      user->setEnabled(true);
   }
   else
   {
      user->setEnabled(false);
   }
}

void appPropPrg::terminalchk()
{
   if(terminal->isChecked()==true)
   {
      tclose->setEnabled(true);
   }
   else
   {
      tclose->setChecked(false);
      tclose->setEnabled(false);
   }
}

#include "apppropprg.moc"
