/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Jun 19 14:43:55 BST 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kcrash.h>
#include <kdebug.h>
#include <kuniqueapplication.h>

#include <stdio.h>
#include <stdlib.h>

#include "kooldock.h"

#define KOOLDOCK_VERSION "0.3"

char *argv0;

#ifndef _ENABLE_DEBUG
extern "C"
{
   static void crashHandler(int /*signal*/)
   {
      char cmd[1024];
      fprintf(stderr, "kooldock: crashHandler called\n");
      sprintf(cmd, "%s &", argv0);
      system(cmd); // try to restart according to argv[0]
   }
}
#endif

static const char *description = I18N_NOOP("<center><b>KoolDock</b></center>A Kool Dock for KDE<br><br>KoolDock is based upon the original work of Dang Viet Dung, Ksmoothdock 2.1<br><br>");

static KCmdLineOptions options[] =
{
   { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
   argv0 = (char *)malloc(sizeof(argv[0]));
   argv0 = argv[0];

   KAboutData aboutData( "kooldock", I18N_NOOP("KoolDock"),
    KOOLDOCK_VERSION, description, KAboutData::License_GPL,
    "(c) 2003, 2004 - KoolDock team", 0, "http://ktown.kde.cl/kooldock", "kooldock-devel@lists.kde.cl");
   aboutData.addAuthor("Matias Fernandez",0, "radix@kde.cl");
   aboutData.addAuthor("Francisco Guidi",0, "francisco@guidi.com", "http://francisco.guidi.com");
   aboutData.addAuthor("Mailing List:", 0, 0, "http://ktown.kde.cl/cgi-bin/mailman/listinfo/kooldock-devel");
   aboutData.addCredit("Mauricio Bahamonde", I18N_NOOP("Project Webmaster"), "elkrammer@kde.cl", "http://ktown.kde.cl/~elkrammer/");
   aboutData.addCredit("Sebastian Sariego Benitez", I18N_NOOP("Icon and artwork"), "segfault@powers.cl", "http://segfault.kde.cl");
   aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));
   KCmdLineArgs::init( argc, argv, &aboutData );
   KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  
   #ifdef _ENABLE_DEBUG
   KApplication::addCmdLineOptions();
   #endif
   #ifndef _ENABLE_DEBUG
   KUniqueApplication::addCmdLineOptions();
   #endif
    
   #ifndef _ENABLE_DEBUG
   if (!KUniqueApplication::start())
   {
      fprintf(stderr, "Kooldock is already running!\n");
      exit(0);
   }
   #endif
  
   #ifndef _ENABLE_DEBUG
   KUniqueApplication a;
   #endif
   #ifdef _ENABLE_DEBUG
   KApplication a;
   #endif
   KoolDock *kooldock = new KoolDock();
   a.setMainWidget(kooldock);
    
   #ifndef _ENABLE_DEBUG
   if(KCrash::crashHandler()!=0)
   {
      kdDebug(0) << "Installing crash handler" << endl;
      KCrash::setEmergencySaveFunction(crashHandler); // Try to restart on crash
   }
   #endif
  
   kooldock->setMainPath(argv0);
   kooldock->show();
   return a.exec();
}
