//
// C++ Interface: setupdialogprg
//
// Description: 
//
//
// Author: KoolDock team <radix@kde.cl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SETUPDIALOGPRG_H
#define SETUPDIALOGPRG_H

#include "setupdialog.h"
#include "apppropprg.h"

// QT includes
#include <qcolor.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qfont.h>
#include <qptrlist.h>
#include <qtabwidget.h>
#include <qpushbutton.h>

// KDE includes
#include <kfontcombo.h>
#include <kcolorcombo.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kfontdialog.h> 
#include <kwinmodule.h>
#include <netwm.h>
#include <klineedit.h>

/**
@author KoolDock team
*/

class KoolDock;

class SetupDialogPrg : public SetupDialog
{
Q_OBJECT
   public:
      SetupDialogPrg(QWidget *parent = 0, const char *name = 0);
      ~SetupDialogPrg();
      appProp *appdlg;
      QString progPath;
      QString menuPath;
      KWinModule *gwm;
      KLineEdit *in;
      QPushButton *up;
      QPushButton *down;
      int grabbing;
      int oldPos;
      QString fileName;
      QStringList fileList;

   public slots:
      void configOK();
      void configCancel();
      void chkSolidSlot();
      void chkImgSlot();
      void chkHidden();
      void chkFont();
      void chkTask();
      void applist_dropped(QDropEvent*,const QValueList<QIconDragItem>&);
      void buttonadd_clicked();
      //void applist_clicked(QIconViewItem *, const QPoint&);
      void appRestart();
      void appFill();
      void appClear();
      void grabWin_clicked();
      void activeWindowChanged(WId id);
      void applist_contextMenuRequested(QIconViewItem*,const QPoint&);
      void removeLauncher();
      void setnewpos(int);
      void xrma_clicked();

   private:
      void computeNewPos(int);
      QTimer *appTimer;
   
   protected:
      void closeEvent( QCloseEvent* );
      void showEvent ( QShowEvent * );
      void hideEvent ( QHideEvent * );
};
#endif
