/***************************************************************************
 *   Copyright (C) 2005 by Conrad Hoffmann                                 *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kdebug.h>

#include <kopetemetacontact.h>
#include <kopeteonlinestatus.h>
#include <kopetegroup.h>

#include "linkedlist.h"


LinkedList::LinkedList( Kopete::Group* group )
	: m_group( group ),
	m_root( 0L ),
	m_current( 0L ),
	m_currentOnlineCount( 0 )
{
}


void LinkedList::insert( Kopete::MetaContact* mc )
{
	LinkedListNode* node = new LinkedListNode( mc );
	if ( m_root == 0L )
	{
		m_root = node;
	}
	else {
		if ( QString::compare( m_root->sortString(), node->sortString() ) < 0 )
		{
			m_root->append( node );
		}
		else
		{
			node->setNext( m_root );
			m_root = node;
		}
	}
}


void LinkedList::clear()
{
	LinkedListNode* node = m_root;
	while ( node != 0L )
	{
		LinkedListNode* bufferNode = node->m_next;
		delete node;
		node = bufferNode;
	}
	m_root = 0L;
}


Kopete::MetaContact* LinkedList::first()
{
	m_current = m_root;
	return m_current->getMetaContact();
}


Kopete::MetaContact* LinkedList::next()
{
	m_current = m_current->m_next;
	if ( m_current == 0L )
	{
		return 0L;
	}
	return m_current->getMetaContact();
}


Kopete::Group* LinkedList::group() const
{
	return m_group;	
}


bool LinkedList::isVisible() const
{
	return m_currentOnlineCount > 0;
}


void LinkedList::setOnlineCount( int count )
{
	m_currentOnlineCount = count;
}


int LinkedList::getOnlineCount() const
{
	return m_currentOnlineCount;
}



LinkedListNode::LinkedListNode( Kopete::MetaContact* mc )
	: m_metaContact( mc ),
	m_next( 0L )
{
	m_sortString = m_metaContact->displayName().lower();
}


const QString& LinkedListNode::sortString()
{
	return m_sortString;
}


void LinkedListNode::append( LinkedListNode* node )
{
	if ( m_next == 0L )
	{
		m_next = node;
	}
	else
	{
		if ( QString::compare( m_next->sortString(), node->sortString() ) < 0 )
		{
			m_next->append( node );
		}
		else
		{
			node->setNext( m_next );
			m_next = node;
		}
	}
}


void LinkedListNode::setNext( LinkedListNode* node )
{
	m_next = node;
}


Kopete::MetaContact* LinkedListNode::getMetaContact() const
{
	return m_metaContact;
}

