//                       -*- mode: C++ -*-
//
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>

#include "silcaccount.h"
#include "silcservercontact.h"
#include "silcmessagemanager.h"

#include <kopetemetacontact.h>
#include <kopetechatsession.h>
#include <kopeteuiglobal.h>

#include <klocale.h>
#include <kmessagebox.h>

SilcServerContact::SilcServerContact(SilcAccount *account,
                                     const QString &nick, 
                                     Kopete::MetaContact *meta,
                                     const QString &icon)
  : SilcContact(account, QString("!%1").arg(nick), meta, icon),
    msgBuffer()
{
  setNickName(nick);
}
 
SilcServerContact::~SilcServerContact() { }

void
SilcServerContact::appendMessage(const QString &text)
{
  Kopete::ContactPtrList members;
  members.append(this);
  Kopete::Message msg(this, members, text, Kopete::Message::Internal);
  
  // we don't want to annoy the user ...
  msg.setImportance(Kopete::Message::Low);

  if(manager() && manager()->view())
    manager()->appendMessage(msg);
  else
    msgBuffer.append(msg);
}

KopeteView *
SilcServerContact::view(void)
{
  KopeteView *view = SilcContact::view();
  if(! view) return NULL;

  while(! msgBuffer.isEmpty()) {
    manager()->appendMessage(msgBuffer.front());
    msgBuffer.pop_front();
  }

  return view;
}

void 
SilcServerContact::slotSendMessage(Kopete::Message &, Kopete::ChatSession *)
{
  
}

Kopete::ChatSession *
SilcServerContact::manager(Kopete::Contact::CanCreateFlags flags)
{
  if(_chatSession) 
    return _chatSession;

  if(! (flags & Kopete::Contact::CanCreate))
    return NULL; // not allowed to create new chat session

  QPtrList<Kopete::Contact> myself;
  myself.append(this);
  
  _chatSession = account()->chatSession(myself);
  _chatSession->setDisplayName(nickName());

  QObject::connect(manager(), SIGNAL(closing(Kopete::ChatSession *)), 
                   this, SLOT(slotCloseSession()));

  return _chatSession;
}

#include "silcservercontact.moc"
