/***************************************************************************
                          insert.cpp  -  description
                             -------------------
    begin                : Seg Dez 30 2002
    copyright            : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kled.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <kapplication.h>
#include "insert.h"
#include "itemxmlfactory.h"

Insert::Insert(QWidget *parent, const char *name ) : Insert_Dlg(parent,name) {
	KIconLoader kil;
	tempItem = 0;
	pb_erase_title->setPixmap( kil . loadIcon( "locationbar_erase.png", KIcon::Toolbar ) );
	pb_erase_content->setPixmap( kil . loadIcon( "locationbar_erase.png", KIcon::Toolbar ) );
	connect( pb_insert, SIGNAL( clicked() ), this, SLOT( slotChangeItem() ) );
	connect( pb_insert, SIGNAL( clicked() ), this, SLOT( slotNewItem() ) );
	connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( slotHelp() ) );
}

Insert::~Insert(){
}

void Insert::slotHelp (){
	kapp->invokeHelp( "item-dialog" );
}

void Insert::slotChangeItem (){
	if (tempItem != 0) {
		tempItem->setTitle (le_title->text());
		tempItem->setContent (le_content->text());

		if ( ButtonGroup1->selected() == rb_yellow ) {
			tempItem->setType(yellow_type);
		}
		if ( ButtonGroup1->selected() == rb_blue ) {
			tempItem->setType(blue_type);
		}
		if ( ButtonGroup1->selected() == rb_red ) {
			tempItem->setType(red_type);
		}
		tempItem->atualizeViewItem();

		this->accept ();
	}
}

void Insert::slotNewItem ()
{
	Type type = yellow_type;
	Position pos = end;

	if (!tempItem) {

		if ( ButtonGroup1->selected() == rb_yellow ) {
			type = yellow_type;
		}
		if ( ButtonGroup1->selected() == rb_blue ) {
			type = blue_type;
		}
		if ( ButtonGroup1->selected() == rb_red ) {
			type = red_type;
		}

		if ( ButtonGroup2->selected() == ins_end ) {
			pos = end;
		}
		if ( ButtonGroup2->selected() == ins_begin ) {
			pos = begin;
		}
		if ( ButtonGroup2->selected() == ins_up ) {
			pos = up;
		}
		if ( ButtonGroup2->selected() == ins_down ) {
			pos = down;
		}
		
		itemXMLfactory ixf (le_title->text(), le_content->text(), type, pos);
		emit newItem( ixf.getDocument() );
		this->accept ();
	}
}

void Insert::setItem ( KpregItem *item ){
	ButtonGroup2 -> setEnabled (false);
	tempItem = item;
	le_title->setText ( tempItem->getTitle() );
	le_content->setText ( tempItem->getContent() );

	if ( tempItem->getType() == blue_type ) {
		rb_blue->setChecked ( true );
		kLed_blue->on();
	}
	if ( tempItem->getType() == red_type ) {
		rb_red->setChecked ( true );
		kLed_red->on();
	}
	if ( tempItem->getType() == yellow_type ) {
		rb_yellow->setChecked ( true );
		kLed_yellow->on();
	}

	Label->setText (i18n("<p align=\"center\"><font size=\"+3\">Edit Item</font></p>"));
}

