/***************************************************************************
                          kpreg.h  -  description
                             -------------------
    begin                : Seg Jul 30 00:39:14 EDT 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPREG_H
#define KPREG_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qclipboard.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qpixmap.h>
#include <qdom.h>

// include files for KDE
#include <kapp.h>
#include <kpopupmenu.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kglobalaccel.h>
#include <kaction.h>
#include <ksystemtray.h>
#include <ktoolbar.h>
#include <kstddirs.h>
//#include <kfile.h>
//#include <kdiroperator.h>

#include "insert.h"
#include "category.h"
#include "kpregsystray.h"
#include "itemxmlfactory.h"

// forward declaration of the Kpreg classes
//class KpregDoc;
class KpregView;

/**
  * The base class for Kpreg application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KpregView creates your center view, which is connected
  * to the window's Doc object.
  * KpregApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.3 code generation
  */
class KpregApp : public KMainWindow
{
Q_OBJECT
friend class KpregView;

public:
	KpregApp(QWidget* parent=0, const char* name=0);
	~KpregApp();
    /** opens a file specified by commandline option
     */
//    void openDocumentFile(const KURL& url=0);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */
//    KpregDoc *getDocument() const;

//	static DockWidget *dock_widget;

protected:

	virtual  void resizeEvent ( QResizeEvent * );

    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
	void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
	void readOptions();

	void initSysTray();
    /** initializes the KActions of the application */
	void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
	void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
//    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
	void initView();
  /** Maneja o arquivo texto em que ser armazenados os dados */
	void initFileDB();
	void importInitFileDB();

    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
//    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */

//    virtual void readProperties(KConfig *_cfg);

  public slots:
    /** open a new application window by creating a new instance of KpregApp */
	void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
//	void slotFileNew();
    /** open a file and load it into the document*/
//	void slotFileOpen();
    /** opens a file from the recent files menu */
//	void slotFileOpenRecent(const KURL& url);
    /** save a document */
	void slotMenuClicked(int);
    /** save a document by a new filename*/
//    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
//	void slotFileClose();
    /** print the actual file */
//	void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
	void slotFileQuit();
    /** paste the clipboard into the document
     */
	void slotEditCategory();
	void slotEditItem();
	void slotAddItem();
	void slotSaveAll ();
	void slotAddCategory ();
	void copyItem ();
	void cutItem ();
	void pasteItensBegin ();
	void pasteItensEnd ();
	void pasteItensAbove ();
	void pasteItensBelow ();
    /** toggles the toolbar
     */
	void slotViewToolBar();
    /** toggles the statusbar
     */
	void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
	void slotStatusMsg(const QString &text);

private:
    /** the configuration object of the application */
	KConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
	KpregView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
	KpregSysTray *kpst;

    // KAction pointers to enable/disable actions
	KAction* fileNewWindow;
//    KAction* fileNew;
//    KRecentFilesAction* fileOpenRecent;
	KAction* fileSave;
//    KAction* fileSaveAs;
//    KAction* fileClose;
//    KAction* filePrint;
	KAction* fileQuit;
	KAction* categoryRight;
	KAction* categoryLeft;
	KAction* itemUp;
	KAction* itemDown;
	KAction* deleteItem;
	KAction* editItem;
	KAction* newItem;
	KAction* newCategory;
	KAction* editCategory;
	KAction* deleteCategory;


	KAction* cut;
	KAction* copy;
	KActionMenu* paste_menu;
	KAction* paste_begin;
	KAction* paste_end;
	KAction* paste_above;
	KAction* paste_below;
//	KAction* open;
//	KAction* saveAs;

	KToggleAction* viewToolBar;
	KToggleAction* viewStatusBar;

	Insert *Ins_Dialog;
	CategoryDialog *Cat_Dialog;
	KPopupMenu *hierMenu;
//	QPopupMenu *pasteMenu;
	KGlobalAccel* pAccel;
};

#endif // KPREG_H
