/***************************************************************************
                          auxwindow.cpp  -  description
                             -------------------
    begin                : Thu Aug 17 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "auxwindow.h"

#include <stdio.h>
#include <unistd.h>
#include <klocale.h>
#include <qaccel.h>


#include "server/server.h"
#include "globals.h"
#include "kpskmeter.h"


#define AUX_DCD   0x01
#define AUX_QPSK  0x02
#define AUX_AFC   0x03
#define AUX_FREQ  0x04
#define AUX_IMD   0x05
#define AUX_DEC_FREQ 0x06
#define AUX_INC_FREQ 0x07


auxWindow::auxWindow(int ch)
{
	clearWFlags (WDestructiveClose);
	channel = ch;
  setCaption (i18n ("Channel ")+QString::number (channel-2));

  initStatusBar();
	luc = new GTTextWidget(this);



  setCentralWidget(luc);

  dcdDialog=NULL;

	oldrxfreq=-1;
	oldafc=-1;
	oldqpsk=-1;
  oldimd=65536;
}

auxWindow::~auxWindow()
{

}

void auxWindow::initStatusBar()
{
	
  statusBar()->insertFixedItem(i18n (" IMD: ---dB "), AUX_IMD, true);
	statusBar()->setItemAlignment (AUX_IMD, AlignLeft | AlignVCenter);
  kpskmeter* sMeter = new kpskmeter(statusBar());
  sMeter -> setChannel(channel);

  statusBar()-> addWidget(sMeter);
 	statusBar()->insertFixedItem(i18n (" QPSK "), AUX_QPSK, true);
	statusBar()->insertFixedItem(i18n (" AFC On "), AUX_AFC, true);
	statusBar()->insertFixedItem(" 9999.9Hz ", AUX_FREQ, true);

  QAccel *b = new QAccel(this);
  b->insertItem (Key_Left+CTRL, AUX_DEC_FREQ);
	b->insertItem (Key_Right+CTRL, AUX_INC_FREQ);
  QObject::connect (b, SIGNAL (activated(int)), this, SLOT (slotStatusBarItemToggle(int)));

	QObject::connect (statusBar(), SIGNAL (pressed(int)), this, SLOT (slotStatusBarItemToggle(int)));

	timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotUpdateStatusBar()));
}

void auxWindow::slotUpdateStatusBar()
{
	int l;
	char rxbuf[256];
	int imd;
  imd = water ->getIMD (channel);
	commGetInfo (channel, &rxinfo, sizeof (rxinfo));

	if (imd != oldimd) {
		oldimd=imd;
    if (imd > 0)
			statusBar()->changeItem (" IMD: ---dB ", AUX_IMD);
    else
			statusBar()->changeItem (" IMD: "+QString::number (imd)+ i18n ("dB "), AUX_IMD);
	}



	if ((rxinfo.freq/10) != oldrxfreq) {
		oldrxfreq = rxinfo.freq/10;
		statusBar()->changeItem (" "+QString::number ((double) (oldrxfreq/10.0), 'f', 1) + i18n ("Hz "), AUX_FREQ);
	}

	if (rxinfo.afc != oldafc) {
		oldafc = rxinfo.afc;
		if (oldafc == 1)
			statusBar()->changeItem (i18n ("AFC On"), AUX_AFC);
		else
			statusBar()->changeItem (i18n ("AFC Off"), AUX_AFC);
  }

	if (rxinfo.qpsk != oldqpsk) {
		oldqpsk = rxinfo.qpsk;
		if (oldqpsk == 1)
			statusBar()->changeItem ("QPSK", AUX_QPSK);
		else
			statusBar()->changeItem ("BPSK", AUX_QPSK);
	}



	 l = commGetData(channel, rxbuf, sizeof rxbuf);
   if(l > 0)
   {
		rxbuf[l] = 0;


// setText prevents autoscrolling as text is added to window
    luc->appendString(rxbuf);


		}
}

void auxWindow::slotStatusBarItemToggle (int id)
{

  if (id == AUX_DEC_FREQ)

     commControl (channel, COMM_FREQ, rxinfo.freq-500);

  if (id == AUX_INC_FREQ)

     commControl (channel, COMM_FREQ, rxinfo.freq+500);

	if (id == AUX_QPSK) {
		if (rxinfo.qpsk ==  0)
			commControl (channel, COMM_QPSK, 1);
		else
			commControl (channel, COMM_QPSK, 0);
	}


	if (id == AUX_AFC) {
		if (rxinfo.afc ==  0)
			commControl (channel, COMM_AFC, 1);
		else
			commControl (channel, COMM_AFC, 0);
	}

  if (id == AUX_FREQ) {
      commControl (COMM_RXCH, COMM_SWAP, channel);

			}



	/*
	 * Handle receive here - not really the right place, but works quite good
   */

}

void auxWindow::reInit()
{
	luc->setFont (config.screen.rxwinfont);
	luc->setColors (config.rxwincolor.rx, config.rxwincolor.tx);
  luc ->setPaletteBackgroundColor(config.bkground.rxb);
}

int auxWindow::getChannel()
{
	return channel;
}
// Start receiving now

void auxWindow::start()
{
  timer->start (50, false);
}

bool auxWindow::queryClose()
{
	// Stop the receiving, before the window will hide
	timer->stop();
	commControl (channel, COMM_MODE, MO_DISABLED);
	luc->clear();
  return true;
}

void auxWindow::clear()
{
luc->clear();
}


int auxWindow::getFreq()
{
	return rxinfo.freq/100;
}
