/***************************************************************************
                          logbook.h  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGBOOK_H
#define LOGBOOK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qvaluelist.h>
#include <qstring.h>
#include "qsoinfo.h"

#include "myqlineedit.h"

#define FIELD_ID				0
#define FIELD_CALLSIGN 	1
#define FIELD_NAME 			2
#define FIELD_QTH 			3
#define FIELD_RSTS 			4
#define FIELD_RSTR 			5
#define FIELD_BAND 			6
#define FIELD_DATE 			7
#define FIELD_TIME 			8
#define FIELD_NOTES 		9

/**
  *@author Luc Langehegermann
  */


class logBook : public QWidget  {
   Q_OBJECT
public: 
	logBook(QWidget *parent=0, const char *name=0);
	~logBook();
	QString getBand();
	QString getCall();
	QString getName();
	QString getNotes();
	QString getQth();
	QString getRstr();
	QString getRsts();
  QString getDate(bool format=0);
	QString getTime(bool format=0);
	QComboBox* bandEdit;
private slots: // Private slots
  void slotFocus ();
  void searchLast();
private: // Private methods
	myQLineEdit* callEdit;
	QLineEdit* nameEdit;
	QLineEdit* qthEdit;
	QLineEdit* rstsEdit;
	QLineEdit* rstrEdit;
	QLineEdit* notesEdit;
	QCheckBox* CallCheckBox;    //ernie
	QSOInfo* qsoinfo;
public slots: // Public slots
  void clear();
  void append();
  void slotSetCall (QString str);
  void showQsoInfo (bool state);
};

#endif
