/***************************************************************************
                          mainview.h  -  description
                             -------------------
    begin                : Mon Jul 3 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAINVIEW_H
#define MAINVIEW_H

#include <qwidget.h>
#include <qsplitter.h>
#include "fixtext.h"
#include "gttextwidget.h"

/**Our Main View Widget for the psk31 Terminal
  *@author Luc Langehegermann
  */

class mainView : public QWidget  {
   Q_OBJECT
public: 
	mainView(QWidget *parent=0);
	~mainView();
  /** Transmit a text - with 0x00 / 0x01 TX/RX switching
 */
  void transmitText (QString str);
  void reInit();
	QSplitter *splitter;
	GTTextWidget* txwindow;
	GTTextWidget* rxwindow;
	fixText* fixtext;

private slots: // Private slots
  void slotRX();
public slots: // Public slots
  void slotTransmitText (char* text);
  void slotEnableCallcheck(bool s);
  void slotClrMainRx();
  void slotClrTx();


};

#endif
