/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kknavigator.h"
#include "kkngroup.h"

#include <klocale.h>
#include <qlabel.h>
#include <qhbox.h>
#include <kiconloader.h>
#include <qtoolbutton.h>
#include <kmainwindow.h>
#include <kaction.h>
#include <kactioncollection.h>
#include <kconfig.h>

KKNavigator::KKNavigator( QWidget* parent, const char* name )
	: QVBox( parent, name ), m_grpOld( 0 )
{
	setFixedWidth( 200 );

	QHBox* hbox = new QHBox( this );
	hbox->setSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed );
	new QLabel( i18n( "Navigator" ), hbox );
	QToolButton* btn = new QToolButton( hbox );
	btn->setIconSet( SmallIcon( "fileclose" ) );
	btn->setAutoRaise( true );
	btn->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
	connect( btn, SIGNAL( pressed() ), this, SLOT( toggleVisible() ) );

	KKNGroup* grp = new KKNGroup( i18n( "Step 1\nSelect Template" ), this );
	grp->setText( "<html><head></head><body>aa</body></html>" );
	grp = new KKNGroup( i18n( "Step 2\nDesign Card" ), this );
	grp = new KKNGroup( i18n( "Step 3\nMake Address Data" ), this );
	grp = new KKNGroup( i18n( "Step 4\nPrint" ), this );

	new QWidget( this );

	new KToggleAction( i18n( "&Navigator" ), "wizard", 0, this, SLOT( toggleVisible() ), actionCollection(), "navigator" );
	KConfig *conf = KGlobal::config();
	conf->setGroup("KKNavigator");
	actionVisible()->setChecked( conf->readBoolEntry( "Visible", true ) );
	m_blVisible = actionVisible()->isChecked();
	if( !m_blVisible )
	{
		hide();
	}
}

KKNavigator::~KKNavigator()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("KKNavigator");
	conf->writeEntry( "Visible", m_blVisible );
}

void KKNavigator::toggleVisible()
{
	m_blVisible = !m_blVisible;
	if( m_blVisible )
	{
		show();
	}
	else
	{
		hide();
	}
	actionVisible()->setChecked( m_blVisible );
}

KActionCollection* KKNavigator::actionCollection()
{
	QPtrList< KMainWindow >* list = KMainWindow::memberList;
	return ((KMainWindow*)list->at(0))->actionCollection();
}

KToggleAction* KKNavigator::actionVisible()
{
	return (KToggleAction*)actionCollection()->action( "navigator" );
}
