/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktcategoryitem.h"
#include "kktitem.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

using namespace KKTemplate;

KKTCategoryItem::KKTCategoryItem( KListView* parent, QDomElement elem, QString path )
	: KListViewItem( parent )
	, m_strPath( path )
{
	readData( elem );
	setOpen( true );
}

KKTCategoryItem::KKTCategoryItem( KListViewItem* parent, QDomElement& elem, QString path )
	: KListViewItem( parent )
	, m_strPath( path )
{
	readData( elem );
}

void KKTCategoryItem::readData( QDomElement elem )
{
	setPixmap( 0, SmallIcon( "folder" ) );

	if( elem.hasAttribute( "path" ) )
	{
		m_strPath += elem.attribute( "path" ) + "/";
	}
	QString lang = KGlobal::locale()->language();
	int i = 0;
	for( QDomNode node = elem.firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		QDomElement e = node.toElement();
		if( e.tagName() == "title" )
		{
			if( ( e.attribute( "lang" ) == "C" && text( 0 ).isEmpty() ) || e.attribute( "lang" ) == lang )
			{
				setText( 0, e.text() );
			}
		}
		else if( e.tagName() == "category" )
		{
			( new KKTCategoryItem( this, e, m_strPath ) )->setText( 1, QString( "%1" ).arg( i++, 3 ) );
		}
		else if( e.tagName() == "template" )
		{
			m_list.append( new KKTItem( e, m_strPath ) );
		}
	}
	m_list.setAutoDelete( true );
}
