/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kreetingkard.h"
#include "kkwidgetbase.h"
#include "kknavigator/kknavigator.h"
#include "kktemplate/kktwidget.h"
#include "kkdesigner/kkdwidget.h"
#include "kkaddressbook/kkawidget.h"

#include <qhbox.h>
#include <qscrollview.h>
#include <qsplitter.h>

#include <klocale.h>
#include <klistview.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <kjanuswidget.h>
#include <kcommand.h>

KreetingKard::KreetingKard()
	: KMainWindow( 0, "KreetingKard" )
{
	m_base = new KJanusWidget( this, 0, KJanusWidget::IconList );
	m_cmdHistory = new KCommandHistory( actionCollection() );

	//BEGIN Template Tab
	QFrame* page = m_base->addVBoxPage( i18n( "Templates" ), i18n( "Templates" ), DesktopIcon( "filenew" ) );
	KKTemplate::KKTWidget* wgt_t = new KKTemplate::KKTWidget( m_cmdHistory, page );
	connect( wgt_t, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_t );
	//END Template Tab

	//BEGIN Design Tab
	page = m_base->addVBoxPage( i18n( "Designer" ), i18n( "Designer" ), DesktopIcon( "kreetingkard" ) );
	KKDesigner::KKDWidget* wgt_d = new KKDesigner::KKDWidget( m_cmdHistory, page );
	connect( wgt_d, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_d );
	//END Design Tab

	//BEGIN AddressBookTab
	page = m_base->addVBoxPage( i18n( "AddressBook" ), i18n( "AddressBook" ), DesktopIcon( "kuser" ) );
	KKDesigner::KKDDoc* doc = wgt_d->document();
	KKAddressBook::KKAWidget* wgt_a = new KKAddressBook::KKAWidget( doc, m_cmdHistory, page );
	connect( wgt_a, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_a );
	//END Address Book Tab

	connect( wgt_t, SIGNAL( open( const QString& ) ), this, SLOT( fileNew( const QString& ) ) );

	connect( m_base, SIGNAL( aboutToShowPage( QWidget* ) ), this, SLOT( activeIndexChanged( QWidget* ) ) );

	setCentralWidget( m_base );
	statusBar()->insertItem( "", 0, 1 );
	statusBar()->setSizeGripEnabled( true );

	KStdAction::quit( this, SLOT( close() ), actionCollection() );

	readConfig();
	activeIndexChanged();
}

KreetingKard::~KreetingKard()
{
	saveConfig();
}

void KreetingKard::readConfig()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("KreetingKard");
	m_base->showPage( conf->readNumEntry( "CurrentPage", 0 ) );
	applyMainWindowSettings( conf, "window" );
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		wgt->readConfig( conf );
	}
}

void KreetingKard::saveConfig()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("KreetingKard");
	conf->writeEntry( "CurrentPage", m_base->activePageIndex() );
	saveMainWindowSettings( conf, "window" );
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		wgt->saveConfig( conf );
	}
}

void KreetingKard::activeIndexChanged( QWidget* )
{
	createGUI( m_pane.at( m_base->activePageIndex() )->xmlFile() );
}

bool KreetingKard::queryClose()
{
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		if( !wgt->closable() ) return false;
	}
	return true;
}

/**
 * @english
 * Open file from templates.
 *
 * @param filename File name to open
 * @endenglish
 *
 * @japanese
 * テンプレートからファイルを開く
 *
 * @param filename 開くファイル名
 * @endjapanese
 */
void KreetingKard::fileNew( const QString& filename )
{
	m_base->showPage( Designer );
	activeIndexChanged();
	((KKDesigner::KKDWidget*)m_pane.at( Designer ))->fileNew( filename );
}

/**
 * @english
 * Open file from command line args ( maybe file.kk is double clicked ).
 *
 * @param filename File name to open
 * @endenglish
 *
 * @japanese
 * コマンドライン引数からファイルを開く（file.kkをダブルクリックした時など）
 *
 * @param filename 開くファイル名
 * @endjapanese
 */
void KreetingKard::fileOpen( const QString& filename )
{
	m_base->showPage( Designer );
	activeIndexChanged();
	((KKDesigner::KKDWidget*)m_pane.at( Designer ))->fileOpen( filename, true );
}

// void KreetingKard::slotStateChanged( const QString& newstate )
// {
// 	kdDebug() << newstate << endl;
// }

// void KreetingKard::readProperties( KConfig* sessionConfig )
// {
// 	kdDebug() << "void KreetingKard::readGlobalProperties( KConfig* sessionConfig )" << endl;
// }
//
// void KreetingKard::saveProperties( KConfig* sessionConfig )
// {
// 	kdDebug() << "void KreetingKard::saveGlobalProperties( KConfig* sessionConfig )" << endl;
// }

QPtrList<KKAddressBook::KKAContactData> KreetingKard::printData()
{
	return ((KKAddressBook::KKAWidget*)m_pane.at( AddressBook ))->printData();
}
