# define for SuSE

%if %{_vendor} == redhat
%define suse_version 0
%endif
%if %{_vendor} == Mandriva
%define suse_version 0
%endif

%define su10 0
%if %{suse_version} == 1000 || %{suse_version} == 1010 || %{suse_version} == 1020
%define su10 1
%endif
%define su9 0
%if %{suse_version} == 900 || %{suse_version} == 910 || %{suse_version} == 920 || %{suse_version} == 930
%define su9 1
%endif

%define _prefix /usr
%define configure_opts %nil

Summary:   POP mail checker for KDE
Name:      kshowmail
Version:   3.2.1
Release:   1
License:   GPL
Vendor:    Eggert Ehmke <eggert.ehmke@berlin.de>
Url:       http://www.sourceforge.net/projects/kshowmail

Packager:  D. Scott Barninger <barninger@fairfieldcomputers.com>
Group:     Mail
Source:    http://prdownloads.sourceforge.net/kshowmail/%{name}-%{version}.tar.gz
#Patch:     %{name}-%{version}-patch
BuildRoot: /var/tmp/kshowmail-root

%if %{su10}
Requires: qt3 >= 3.3, kdelibs3 >= 3.4
BuildRequires: qt3-devel >= 3.3, kdelibs3-devel >= 3.4, kdepim3-devel
%else
Requires: qt >= 3.2, kdelibs >= 3.1
BuildRequires: qt-devel >= 3.2, kdelibs-devel >= 3.1, kdepim3-devel
%endif

%description
kShowmail is a KDE tool for watching for email on POP3 servers. 
Headers and complete email messages can be displayed, and email can 
be deleted without downloading. The information can be refreshed via timers, 
and a sound can be played when new email arrives. External programs like 
fetchmail/sendmail can be called via configurable menu entries or if new mail 
arrives. Spam complaints can also be sent via configurable menus.

%prep
%setup
#%patch -p1

./configure %{configure_opts}

%build

make 

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"
make install DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.kshowmail
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.kshowmail
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.kshowmail

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"
rm -rf $RPM_BUILD_DIR/kshowmail-%{version}
rm -rf ../file.list.kshowmail


%files -f ../file.list.kshowmail
%doc AUTHORS ChangeLog COPYING README ReleaseNotes

%changelog
* Fri Jul 06 2007 <scott at fairfieldcomputers dot com>
- added docs files
* Sat Apr 21 2007 <scott at fairfieldcomputers dot com>
- remove parallel build setup
* Sat Apr 14 2007 <scott at fairfieldcomputers dot com>
- remove all configure options so 64 bit will work
- set prefix to /usr
- move kdepim3-devel to buildrequires
* Fri Mar 30 2007 <scott at fairfieldcomputers dot com>
- add additional 64 bit configure options
* Sun Mar 18 2007 <scott at fairfieldcomputers dot com>
- add suse platform detection
- change make install-strip target to make install
* Sun Feb 25 2007 <scott at fairfieldcomputers dot com>
- add kdepim-devel build requirement
* Sun Dec 17 2006 <scott at fairfieldcomputers dot com>
- add 64 bit support
* Tue Jan 24 2006 <scott at fairfieldcomputers dot com>
- patch showrecordelem.cpp for SuSE 10.0 build
- define SuSE prefix to /opt/kde3
* Sat Sep 13 2003 <scott at fairfieldcomputers dot com>
- initial spec file modified from original by ian geiser <geiseri at msoe dot edu>
- for RedHat
