/***************************************************************************
                          showlistviewitem.h  -  description
                             -------------------
    begin                : Son Apr 21 2002
    copyright            : (C) 2002 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SHOWLISTVIEWITEM_H
#define SHOWLISTVIEWITEM_H

#include <qlistview.h>

/**
  *@author Eggert Ehmke
  */

class ShowListViewItem : public QListViewItem
{
public:

  /**
   * Constructor
   * @param parent mail list view
   * @param after insert the new item after this item
   */
  ShowListViewItem (QListView * parent, ShowListViewItem * after);

  /**
   * Constructor
   * @param parent mail list view
   */
  ShowListViewItem( QListView* parent );


  virtual	~ShowListViewItem();
  virtual QString key (int column, bool ascending) const;
  /**
    * reimplement compare to solve bug #856005
    * standard compare is locale dependant
    */
  virtual int compare( QListViewItem *i, int col, bool ascending ) const;
  void setNumber (const QString&);
  void setAccount(const QString&);
  void setFrom(const QString&);
  void setTo(const QString&);
  void setSubject(const QString&);
  void setDate(const QString&);
  void setSize(const QString&);
  void setContent(const QString&);
  void setState(const QString&);
  void setTime (const QString&);
  enum {_colNumber, _colAccount, _colFrom, _colTo, _colSubject, _colDate,
        _colSize, _colContent, _colState};
private:
	QString m_time;
};


#endif
