/***************************************************************************
                          uniqueapp.cpp  -  description
                             -------------------
    begin                : Mon Nov 19 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uniqueapp.h"
#include <iostream>


UniqueApp::UniqueApp()
{
	m_pApp = NULL;
}

UniqueApp::~UniqueApp()
{}

int UniqueApp::newInstance ()
{
  //start our application
  //---------------------

  //at the first invoke of newInstance() create a new instance of kshowmail
  if (m_pApp == NULL)
  {
    m_pApp = new KShowMailApp ();
  }

  //frage das ConfigList-Objekt, ob die KShowMail beim Starten
  //normal oder nur in der Taskleiste gezeigt werden soll
  if( m_pApp->m_ConfigList.startMinimized() )
  {
    //lege die App auf die Taskleiste
    m_pApp->showMinimized ();
    m_pApp->hide();
  }
  else
  {
    //zeige das Hauptfenster
    m_pApp->showNormal ();
    m_pApp->raise();
  }

  //Kommandozeile-Argumente auswerten
  //---------------------------------

  //die in main() eingelesenen Kommandozeile-Argumente in ein
  //KCmdLineArgs-Objekt ablegen
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  //wenn als Kommandozeilen-Argument "config" übergeben wurde,
  //starte jetzt den Konfigurationsdialog
  if ( args->isSet( CMDLINE_CONFIG ) )
    m_pApp->slotSetup();

  //wenn als Kommandozeile-Argument "refresh" übergeben wurde,
  //schaue sofort nach neue Mails
  if ( args->isSet ( CMDLINE_REFRESH ) )
    m_pApp->slotRefresh();

  //lösche alle Kommandozeilen-Argumente im Objekt
  args->clear ();

  return 0;
}
