/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#include <qdir.h>
#include <qmap.h>
#include <qstringlist.h>

/*! Reads & writes a config file

	This is a modified version of the config.h from
	qt designer.

	The file lookes like this:
	[group1]
	value1 = ...
	value2 = ...
	[group2]
	value1 = ...
	value2 = ...
	...

	Example:
	bool myClass::saveDialogSettings(const QString &filename)
	{
		Config ConfigFile(filename);
		if (ConfigFile.ok())
		{
			ConfigFile.setGroup("DialogSettings");

			ConfigFile.writeEntry("x", pos().x());
			ConfigFile.writeEntry("y", pos().y());
			ConfigFile.writeEntry("width", size().width());
			ConfigFile.writeEntry("height", size().height());

			return ConfigFile.write();
		}
		else
			return false;
	}

	\version 1.0
	Changes:
	- bool ok() added.
	- void removeGroup(...) added.
	- void removeEntry(...) added.
	- double readNumEntry(...) added.
	- void writeEntry(..., double num) added.
	- The file is now only written if writeEntry is called at least once.
*/
class Config
{
public:
    typedef QMap< QString, QString > ConfigGroup;
    
    Config( const QString &fn );
    ~Config();
    
    void setGroup( const QString &gname );
    void writeEntry( const QString &key, const QString &value );
    void writeEntry( const QString &key, int num );
    void writeEntry( const QString &key, double num );
    void writeEntry( const QString &key, bool b );
    void writeEntry( const QString &key, const QStringList &lst, const QChar &sep );
    
    QString readEntry( const QString &key, const QString &deflt = QString::null );
    int readNumEntry( const QString &key, int deflt = -1 );
    double readNumEntry( const QString &key, double deflt = 0.0 );
    bool readBoolEntry( const QString &key, bool deflt = FALSE );
    QStringList readListEntry( const QString &key, const QChar &sep ); 
    
    void removeGroup(const QString &gp);
    void removeEntry(const QString &key);

    void clearGroup();
    
    bool write( const QString &fn = QString::null );
    bool ok();
    
protected:
    bool read();
    void parse( const QString &line );
    
    QMap< QString, ConfigGroup > groups;
    QMap< QString, ConfigGroup >::Iterator git;
    QString filename;
		bool m_bOk;
		bool m_bChanged;
};

#endif
