/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOCIOMETRICTEST_H
#define SOCIOMETRICTEST_H

#include <qstring.h>
#include <qmap.h>


class sociometricTest  
{
public:
    sociometricTest();

    ~sociometricTest();
    
private:


   //  propiedades generales del test
   QString RutaFicheroTest;  // la ruta completa absoluta del path (es una URL en formato QString)
   int numeroElecciones;  // Numero de elecciones constanate 3 o 5 o 0
   bool CriterioSociotelico;
   bool CriterioPsicotelico;
   bool CriterioAutoridad;
   bool CriterioAfinidad;
   bool CriterioPropio;

   // propiedades generales del grupo
   QString NombreInstitucion;
   QString NombreTutor;
   QString DescripcionGrupo;
   QString IdentificativoGrupo;
   int NumeroAlumnosGrupo;



   // matrices para guardar la base de datos de alumnos
   //Por tanto, se crean varias
   // matrices que se gestionaran a traves de funciones de
   // de escritura y lectura, indicando siempre el index (indice)
   // del alumno que se desea procesar.
   QString NombreAlumno[100]; //string
   int EdadAlumno[100]; // int
   QString SexoAlumno[100]; // string
   QString IdentificativoAlumno[100]; //string
   
   
   //matrces para guardar las respuestas de los alumnos al cuestionario
   // siendo array[AlumnoEnEvaluacion,PosicionEleccion] = AlumnoSeleccionado
   int eleccion[100][100]; //integer;
   int rechazo[100][100]; //integer;
   int PercepcionEleccion[100][100]; //integer;
   int PercepcionRechazo[100][100]; //integer;
   
   // matrices para guardar los valores sociometricos  en general de cada alumno
   int Sp[100]; //integer; // status de elecciones
   int Spv[100]; //integer; // status de elecciones valorizadas
   int Sn[100]; //integer; // status de rechazos
   int Snv[100]; //integer; // status de rechazos valorizados
   int Ep[100]; //integer; //  expansividad positiva
   int En[100]; //integer; // expansividad negativa
   int Rp[100]; //integer; // Elecciones reciprocas
   int Rpv[100]; //integer; // Elecciones reciprocas ponderadas
   int Rn[100]; //integer; // Rechazos reciprocos
   int Rnv[100]; //integer; // Rechazos reciprocos ponderados
   int OS[100]; //integer; // Oposicion de sentimiento

   // matrices para guardar los valores sociometricos  en relacion al criterio de percepcion de cada alumno
   int Pp[100]; //integer; // percepcion de elecciones
   int PAp[100]; //integer; // percepcion acertada de elecciones
   int Pn[100]; //integer; // percepcion de rechazo
   int PAn[100]; //integer; // percepcion acertada de rechazo
   int Ip[100]; //integer; // Impresion de elecciones
   int In[100]; //integer; // Impresion de rechazos
   int FP[100]; //integer; // Falsa percepcion

   
   // indices sociometricos individuales
   double Pop[100]; // indice de popularidad
   double Ant[100]; // indice de antipatia
   double Expp[100]; // indice de expansion positiva
   double Expn[100]; // indice de expansion negativa
   double CA[100]; // indice de conexion afectiva
   double AP[100]; // indice de atencion perceptiva
   double RPER[100]; // indice de realismo perceptivo
   double SS[100]; // status sociometrico


   double Param_P; // real;
   double Param_Q; // real;
   double Param_Med;  // media
   double Param_Desv; // desviacion tipica
   double Param_Asim; // asimetria de la curva

   
   
   

   bool EsEvaluado[100]; // flash para saber si un alumno ya ha sido evaluado


   
   
   bool tarea1, tarea2, tarea3, tarea4;
   bool strongElectionSociogram, weakElectionSociogram, strongRejectionSociogram, weakRejectionSociogram, reciprocalElectionSociogram, reciprocalRejectionSociogram, reciprocalElectionAndRejectionSociogram;



   
   
   // guarda el valor del estudiante para el test individual sociomtrico
   int studentShow;
   QString sociogramShow;
    QString Question1;
    QString Question2;
    QString Question3;
    QString Question4;
    
    
    
    
    
    int reciprocalElectionAndRejection_Cx[100];
    int reciprocalElectionAndRejection_Cy[100];
    
    int reciprocalElection_Cx[100];
    int reciprocalElection_Cy[100];
    
    int reciprocalRejection_Cx[100];
    int reciprocalRejection_Cy[100];
    
    int strongRejection_Cx[100];
    int strongRejection_Cy[100];
    
    int strongElection_Cx[100];
    int strongElection_Cy[100];
    
    int weakRejection_Cx[100];
    int weakRejection_Cy[100];
    
    int weakElection_Cx[100];
    int weakElection_Cy[100];


//******************************************************************************
   protected:
   // no hay variables protected, ya que este componente no va a servir para
   // derivar otro componente

//*****************************************************************************
   public:
      
   QString getRutaFicheroTest();  // la ruta completa absoluta del path, terminada en /
   void setRutaFicheroTest(QString);
   
   int getNumeroElecciones();  // Numero de elecciones constanate 3 o 5 o 0
   void setNumeroElecciones(int);
   
   bool getCriterioSociotelico();
   void setCriterioSociotelico(bool);
   
   bool getCriterioPsicotelico();
   void setCriterioPsicotelico(bool);
   
   bool getCriterioAutoridad();
   void setCriterioAutoridad(bool);
   
   bool getCriterioAfinidad();
   void setCriterioAfinidad(bool);


   
   // propiedades generales del grupo
   QString getNombreInstitucion();
   void setNombreInstitucion(QString);
   QString getNombreTutor();
   void setNombreTutor(QString);
   QString getDescripcionGrupo();
   void setDescripcionGrupo(QString);
   QString getIdentificativoGrupo();
   void setIdentificativoGrupo(QString);
   int getNumeroAlumnosGrupo();
   void setNumeroAlumnosGrupo(int);
   
   

   // procedimientos que gestionan la la base de datos de alumnos
   // Value es el index (indice) del alumno. Ademas Value2 es la cadena o entero a almacenar
   QString getNombreAlumno (int);
   void setNombreAlumno (int, QString); //Value1 es el indice del alumno y Value2 es la cadena con el nombre
   int getEdadAlumno (int);
   void setEdadAlumno (int, int); //Value1 es el indice del alumno y Value2 es el entero con la edad
   QString getSexoAlumno (int);
   void setSexoAlumno (int, QString); //Value1 es el indice del alumno y Value2 es la cadena con el sexo
   QString getIdentificativoAlumno (int);
   void setIdentificativoAlumno (int, QString); //Value1 es el indice del alumno y Value2 es la cadena con el identificativo
   
   
   // funciones que gestionan las respuestas al cuestionario de los alumnos
   // Value1 es Index de AlumnoEnEvaluacion, Value2 es Orden en seleccion, Value3 es Index de Alumno seleccionado (clickado)
   void setEleccion (int, int, int);
   int getEleccion (int, int);
   void setRechazo (int, int, int);
   int getRechazo (int, int);
   void setPercepcionEleccion (int, int, int);
   int getPercepcionEleccion (int, int);
   void setPercepcionRechazo (int, int, int);
   int getPercepcionRechazo (int, int);


   
   
   
   // funciones que gestionan los valores sociometricos  generales de los alumnos
   // value es el index del alumno
   int getSp (int);  // status de elecciones
   int getSpv (int); // status de elecciones valorizadas
   int getSn (int); // status de rechazos
   int getSnv (int); // status de rechazos valorizados
   int getEp (int); //  expansividad positiva
   int getEn (int); //  expansividad negativa
   int getRp (int); // Elecciones reciprocas
   int getRpv (int); // Elecciones reciprocas ponderadas
   int getRn (int); // Rechazos reciprocos
   int getRnv (int); // Rechazos reciprocos ponderados
   int getOS (int); // Oposicion de sentimiento
   
   // funciones que gestionan los valores sociometricos  (percepciones) de los alumnos
   // value es el index del alumno
   int getPp (int);  // percepcion de elecciones
   int getPAp (int);  // percepcion acertada de elecciones
   int getPn (int);  // percepcion de rechazo
   int getPAn (int);  // percepcion acertada de rechazo
   int getIp (int);  // Impresion de elecciones
   int getIn (int);  // Impresion de rechazos
   int getFP (int);  // Falsa percepcion

   //funcion de calculo de la distancia socometrica entre Value1 y Value2
   int getDistSociometrica(int, int);


   // procedimiento para calcular los parametros estadisticos de la muestra:
   // p, q, med, desv, asim
   // QString es una cadena con el valor sociometrico (Sp,Sn etc...)
   void ParametrosEstadisticos (QString);


   // parametros estadisticos de la muestra
   // QString es el estadisticos para el que se calcula el parmetro
   double getParam_P (QString); // real;
   double getParam_Q (QString); // real;
   double getParam_Med (QString);  // media
   double getParam_Desv (QString); // desviacion tipica
   double getParam_Asim (QString); // asimetria de la curva
   
   
   
   



   // funciones para el calculo de significacion
   // funcion que calcula el limite superior del estadistico t
   // bajo la teoria de <<probabilidad teorica del azar>>
   // QString es el valor sociometrico (Sp,Sn, etc...)
   double getLimSup(QString);

   // funcion que calcula el limite inferior del estadistico t
   // bajo la teoria de <<probabilidad teorica del azar>>
   // QString es el valor sociometrico (Sp,Sn, etc...)
   double getLimInf(QString);


   int getEleccionesIntraGrupo (QString); // Value es Hombre o Mujer
   int getEleccionesExtraGrupo (QString); // Value es Hombre o Mujer


   // indices sociometricos individulaes
   double getPop (int); // indice de popularidad
   double getAnt (int); // indice de antipatia
   double getExpp (int); // indice de expansion positiva
   double getExpn (int); // indice de expansion negativa
   double getCA (int); // indice de conexion afectiva
   double getAP (int); // indice de atencion perceptiva
   double getRPER (int); // indice de realismo perceptivo
   double getSS (int); // status sociometrico
   
   
   // indice sociometricos globales
   
   double getGIA(); // indice de asociacion
   double getGID(); // indice de disociacion
   double getGIC(); // indice de coherencia
   double getGIS(); // indice de intensidad social
   double getGPS(QString); // indice de preferencias del subgrupo (Value: Hombre o Mujer)
   double getGUS(QString); // indice de union del subgrupo (Value: Hombre o Mujer)


   // propiedades con las tareas pendientes y terminadas
   bool getTarea1();
   void setTarea1(bool);
   bool getTarea2();
   void setTarea2(bool);
   bool getTarea3();
   void setTarea3(bool);
   bool getTarea4();
   void setTarea4(bool);
   void setTarea(QString typeSociogram, bool value);
   bool getTarea(QString typeSociogram);


   // procedimientos para grabar los datos de cada tarea en el fichero ini
   void GrabaDatosGeneralesTest (QString filename);
   void GrabaDatosGeneralesGrupo (QString filename);
   void GrabaBaseDatosAlumnos (QString filename); 
   bool GrabaRespuestas (int value, QString filename); // value es el numero del alumno que ha respondido


   // procedimientos para cargar del disco los datos desde el fichero ini
   bool CargaDatosGeneralesTest (QString filename);
   bool CargaDatosGeneralesGrupo (QString filename);
   bool CargaBaseDatosAlumnos (QString filename);
   bool CargaRespuestas (QString filename);
   
   // procedimiento para saber si un alumno ha realizado el cuestionario
   bool getEsEvaluado(int);
   void setEsEvaluado(int idStudent, bool value);
   
   int getNumeroAlumnosSexo (QString); // Value es Hombre o Mujer


//******************************************************************************
  
   
   // guarda el alumno que se muestra en el sociograma individual
   void setStudentShow(int idStudent);
   int getStudentShow();
   void setSociogramShow(QString typeSociogram);
   QString getSociogramShow();
   double getSociometricValue(QString sValue, int idStudent);
    int isReciprocalElection(int n, int m);
    int isReciprocalRejection(int m, int n);
    void savePosition(QString typeSociogram, QString filename);
    int getCx(int idStudent,QString typeSociogram);
    int getCy(int idStudent,QString typeSociogram);
    void setCx(int idStudent, QString typeSociogram, int x);
    void setCy(int idStudent, QString typeSociogram, int x);
    int isElection(int m, int n);
    int isRejection(int m, int n);
    bool loadPosition(QString filename);
    QString getQuestion1();
    QString getQuestion2();
    QString getQuestion3();
    QString getQuestion4();
    int numberStudentsEvaluated();
    void saveTasks(QString filename);
    void removeStudent(int idStudent, QString filename);
    void newTest();
    void setCriterioPropio(bool value);
    bool getCriterioPropio();
    void setQuestion1(QString text);
    void setQuestion2(QString text);
    void setQuestion3(QString text);
    void setQuestion4(QString text);
    int numberStudentsInDataBase();

    //flag para test modificado del cargado de disco o nuevo (vaco)
    bool isChangedTest;
    int modeAccess; //0=modo administrador, 1=modo cuestionarios

    
    

    
};

#endif
