/***************************************************************************
 *   Copyright (C) 2005 by Silpa & Kamesh                                  *
 *   us@avasarala                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "ktemperaturewidget.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <qaccel.h> 

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char version[] = "1.4";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("ktemperature", I18N_NOOP("KTemperature"), version, description,
                     KAboutData::License_GPL, "(C) %{YEAR} Silpa & Kamesh", 0, 0, "us@avasarala");
    about.addAuthor( "Silpa & Kamesh", 0, "us@avasarala" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KTemperatureWidget *mainWin = NULL;
    KSystemTray        *systemTray = NULL;
    KPopupMenu	       *systemTrayMenu = NULL;
    QFont sysTrayFont("Times New Roman", 15, QFont::Bold);
    QAccel 		*sysTrayAccel;
    
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

     /// @todo do something with the command line args here

    mainWin = new KTemperatureWidget();
    app.setMainWidget( mainWin );
    systemTray = new KSystemTray(mainWin);
    systemTrayMenu = systemTray->contextMenu();
    sysTrayAccel = new QAccel(systemTrayMenu);
    
    systemTrayMenu->insertItem("Pause",mainWin,SLOT(pause()),0,ID_PAUSE,-1);
    systemTrayMenu->setAccel(Qt::CTRL + Qt::Key_P,ID_PAUSE);
    sysTrayAccel->connectItem(sysTrayAccel->insertItem(Qt::Key_P+Qt::CTRL),mainWin,SLOT(pause(void))); 
    
    systemTrayMenu->insertItem("Restart",mainWin,SLOT(restart()),0,ID_RESTART,-1);
    systemTrayMenu->setAccel(Qt::CTRL + Qt::Key_R,ID_RESTART);
    sysTrayAccel->connectItem(sysTrayAccel->insertItem(Qt::Key_R+Qt::CTRL),mainWin,SLOT(restart(void))); 
    
    systemTrayMenu->insertItem("Update",mainWin,SLOT(update()),0,ID_UPDATE,-1);
    systemTrayMenu->setAccel(Qt::CTRL + Qt::Key_U,ID_UPDATE);
    sysTrayAccel->connectItem(sysTrayAccel->insertItem(Qt::Key_U+Qt::CTRL),mainWin,SLOT(update(void))); 
    
    systemTrayMenu->setItemEnabled(ID_RESTART,FALSE);
    systemTrayMenu->setItemEnabled(ID_UPDATE,FALSE);
    systemTrayMenu->insertItem("About",mainWin,SLOT(about()),0,ID_ABOUT,-1);
    systemTray->setBackgroundMode(Qt::PaletteBackground);
    systemTray->setFont(sysTrayFont);
    systemTray->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    mainWin->setTrayReference(systemTray);
    systemTray->show();
    args->clear();
    return app.exec();
}

