/***************************************************************************
                          predictionlist.cpp  -  description
                             -------------------
    begin                : Wed Aug 7 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "predictionlist.h"

#include <qcombobox.h>
#include <qdatetimeedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <klocale.h>

predictionList::predictionList(QWidget *parent, const char *name, WFlags fl ) : predictionListBase(parent,name,fl) {
  listView->setAllColumnsShowFocus(true);
  listView->addColumn(i18n("Date"));
  listView->addColumn(i18n("Longitude"));
  listView->addColumn(i18n("Latitude"));
  listView->addColumn(i18n("El"));
  listView->addColumn(i18n("Az"));
  listView->addColumn(i18n("Range"));
  listView->addColumn(i18n("Velocity"));
  listView->addColumn(i18n("Orbit Number"));
  listView->addColumn(i18n("MA"));
  listView->addColumn(i18n("Squint"));
  listView->setColumnAlignment(1,AlignRight);
  listView->setColumnAlignment(2,AlignRight);
  listView->setColumnAlignment(3,AlignRight);
  listView->setColumnAlignment(4,AlignRight);
  listView->setColumnAlignment(5,AlignRight);
  listView->setColumnAlignment(8,AlignRight);
  listView->setColumnAlignment(7,AlignRight);
  listView->setColumnAlignment(6,AlignRight);
  listView->setColumnAlignment(9,AlignRight);
}
predictionList::~predictionList(){
}
/** No descriptions */
void predictionList::setSatList(QList<satellite> s)
{
  satlist=s;
  // fill the satellite selection combo box
  satellite* sat;
  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    if(sat->polled()) satnameCombo->insertItem(sat->name());
  }
  // default values for the times
  startEdit->setDateTime(QDateTime::currentDateTime());
  stopEdit->setDateTime(QDateTime::currentDateTime().addDays(1));
  stepEdit->setValue(5);

  // connect the push buttons

  QObject::connect(calculateButton, SIGNAL(clicked()), this, SLOT(slotCalculate()));
  QObject::connect(dismissButton, SIGNAL(clicked()), this, SLOT(slotDismiss()));

}
/** No descriptions */
void predictionList::slotDismiss(){
  close();
}
/** No descriptions */
void predictionList::slotCalculate(){
  struct tm TM;
  time_t t = time(0);
  TM=*gmtime(&t);
  bzero(&TM, sizeof(tm));
  // clear the list view
  listView->clear();
  listView->setSorting(-1); // disable sorting
  QDateTime date = startEdit->dateTime();

  // get the sat

  satellite* sat;

  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    if (sat->name() == satnameCombo->currentText()) {
      break;
    }
  }

  for(;;) {
    qDateTime2tm(date, &TM);
    sat->propagator->calc(&TM, false);

    if (sat->elevation() < 0.0) {   // advance to the next aos
        qDateTime2tm(date, &TM);
        sat->propagator->calc(&TM, true);
        date = daynum2QDateTime(sat->nextAosLos());
        qDateTime2tm(date, &TM);
        sat->propagator->calc(&TM, false);
    }
    if (date < stopEdit->dateTime()) insertItem(sat, date);                                
    date = date.addSecs(60*stepEdit->value());
    if (date >= stopEdit->dateTime()) break;
  }
  sat->propagator->resetAosLos();
}
/** No descriptions */
double predictionList::qDateTime2daynum(QDateTime date){
  // create tm struct
  struct tm TM;
  TM.tm_sec=date.time().second();
  TM.tm_min=date.time().minute();
  TM.tm_hour=date.time().hour();
  TM.tm_mday=date.date().day();
  TM.tm_mon=date.date().month()-1;
  TM.tm_year=date.date().year()-1900;

  time_t t = mktime(&TM);
  return (((double)t/86400.0)-3651.0);
}
/** No descriptions */
void predictionList::qDateTime2tm(QDateTime date, struct tm* TM){

  TM->tm_sec=date.time().second();
  TM->tm_min=date.time().minute();
  TM->tm_hour=date.time().hour();
  TM->tm_mday=date.date().day();
  TM->tm_mon=date.date().month()-1;
  TM->tm_year=date.date().year()-1900;
  time_t t = mktime(TM);
  gmtime_r(&t, TM);
  TM->tm_year+=1900;
  TM->tm_mon+=1;
}

/** No descriptions */
QDateTime predictionList::daynum2QDateTime(double daynum){
  QDateTime date;
  extern long timezone;
	tzset();
	struct tm TM;
  bzero(&TM, sizeof(tm));
	Calendar_Date(daynum, &TM);
	Time_of_Day(daynum, &TM);
	TM.tm_year-=1900;
	TM.tm_mon-=1;
	time_t t = mktime(&TM);
	t=t-timezone;
//  TM = *localtime(t);
  
  
//  TM.tm_sec=date.time().second();
//  TM.tm_min=date.time().minute();
//  TM.tm_hour=date.time().hour();

  date.setTime_t(t);
  return date;

//	char* r = ctime(&t);
//	r[strlen(r)-1]=0;
//	return r;
}
/** No descriptions */
void predictionList::insertItem(satellite* sat, QDateTime date){
    QListViewItem* item = new QListViewItem(listView, date.toString(), QString::number(sat->longitude(), 'f', 2),
      QString::number(sat->latitude(), 'f', 2), QString::number(sat->elevation(), 'f', 1),
      QString::number(sat->azimuth(), 'f', 1), QString::number(sat->range(), 'f', 1),
      QString::number(sat->velocity()), QString::number(sat->orbitnum()));
    item->setText(8, QString::number(sat->ma(), 'f', 1));
    if(sat->squinttype() != 0)
      item->setText(9, QString::number(sat->squint(), 'f', 1)+ " ");
    else
      item->setText(9, "--.-");
}
