///////////////////////////////////////////////////////////////////////////////
//
//   File : kvi_osinfo.cpp
//   Creation date : 19  Jan 2006 GMT by Alexey Uzhva
//
//   This toolbar is part of the KVirc irc client distribution
//   Copyright (C) 2006 Alexey Uzhva
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
///////////////////////////////////////////////////////////////////////////////

#define __KVILIB__

#include "kvi_osinfo.h"
#include "kvi_locale.h"

#ifndef COMPILE_ON_WINDOWS
	#include <sys/utsname.h>
	#include <stdlib.h>
	#include <unistd.h>
#endif

#ifdef COMPILE_ON_WINDOWS
#include <windows.h>
typedef enum WindowsVersion
{
		Win_Unknown = 0,
		Win98,
		Win98_SE,
		WinMe,
		WinNT_Unknown,
		WinNT_40_Workstation,
		WinNT_40_Server,
		WinNT_40_Server_Enterprise,
		Win2000_Unknown,
		Win2000_Professional,
		Win2000_Server,
		Win2000_Server_Datacenter,
		Win2000_Server_Advanced,
		WinXP_Unknown,
		WinXP_Home,
		WinXP_Professional,
		WinServer2003,
		WinServer2003_Enterprise,
		WinServer2003_Datacenter,
		WinServer2003_WebEdition,
		Win32s,	
};

typedef enum QueryInfo
{
	Os_Release,
	Os_Version,
	Os_Type
};

static QString queryWinInfo( QueryInfo info)
{
	WindowsVersion	iWinVersion;
	OSVERSIONINFOEX vOsvi;
	bool m_bOsVersionInfoEx = FALSE;
	iWinVersion = Win_Unknown;	
	// Try calling GetVersionEx using OSVERSIONINFOEX.
	ZeroMemory(&vOsvi, sizeof(OSVERSIONINFOEX));
	vOsvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	
	if( !(m_bOsVersionInfoEx = GetVersionEx ((OSVERSIONINFO *) &vOsvi)) )
	{
		// If that fails, try using OSVERSIONINFO.
		vOsvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
		if (! GetVersionEx ( (OSVERSIONINFO *) &vOsvi) ) 
			return 0;
	}
	
	switch (vOsvi.dwPlatformId)
	{

	// is a Nt?
	case VER_PLATFORM_WIN32_NT:
		
		// what's family?
		if ( vOsvi.dwMajorVersion == 5 && vOsvi.dwMinorVersion == 2 )
            iWinVersion = WinServer2003;
		
		if ( vOsvi.dwMajorVersion == 5 && vOsvi.dwMinorVersion == 1 )
			iWinVersion = WinXP_Unknown;
		
		if ( vOsvi.dwMajorVersion == 5 && vOsvi.dwMinorVersion == 0 )
			iWinVersion = Win2000_Unknown;
		
		if ( vOsvi.dwMajorVersion <= 4 )
            iWinVersion = WinNT_Unknown;
		
		// Windows NT 4.0 SP6 or later ?
		if( m_bOsVersionInfoEx )
		{
            // Test for the workstation type.
            if ( vOsvi.wProductType == VER_NT_WORKSTATION )
            {
				if( vOsvi.dwMajorVersion == 4 )
					iWinVersion = WinNT_40_Workstation;
				else if( vOsvi.wSuiteMask & VER_SUITE_PERSONAL )
				{
					if(vOsvi.dwMinorVersion == 1)
						iWinVersion = WinXP_Home;
				}
				else
				{
					if(vOsvi.dwMinorVersion == 1)
						iWinVersion = WinXP_Professional;
					else if(vOsvi.dwMinorVersion == 0)
						iWinVersion = Win2000_Professional;
				}
            }
            
            // is a server?
            else if ( vOsvi.wProductType == VER_NT_SERVER )
            {
				// Windows Server 2003
				if( vOsvi.dwMajorVersion == 5 && vOsvi.dwMinorVersion == 2 )
				{
					if( vOsvi.wSuiteMask & VER_SUITE_DATACENTER )
						iWinVersion = WinServer2003_Datacenter;
					else if( vOsvi.wSuiteMask & VER_SUITE_ENTERPRISE )
						iWinVersion = WinServer2003_Enterprise;
					else if ( vOsvi.wSuiteMask == VER_SUITE_BLADE )
						iWinVersion = WinServer2003_WebEdition;
					else
						iWinVersion = WinServer2003;
				}
				
				// Windows 2000
				else if( vOsvi.dwMajorVersion == 5 && vOsvi.dwMinorVersion == 0 )
				{
					if( vOsvi.wSuiteMask & VER_SUITE_DATACENTER )
						iWinVersion = Win2000_Server_Datacenter;
					else if( vOsvi.wSuiteMask & VER_SUITE_ENTERPRISE )
						iWinVersion = Win2000_Server_Advanced;
					else
						iWinVersion = Win2000_Server;
				}
			}
		}
		break;				  
		case VER_PLATFORM_WIN32s:
			iWinVersion = Win32s;
		break;
	}
	if(info==Os_Release)
	{
		unsigned long major = vOsvi.dwMajorVersion;
		unsigned long minor = vOsvi.dwMinorVersion;
		unsigned long release = vOsvi.dwBuildNumber;
		QString szMajor, szMinor, szRelease, szVersion;
		szMajor.setNum(major);
		szMinor.setNum(minor);
		szRelease.setNum(release);
		szVersion = "Release : "+szMajor +"."+ szMinor +"."+ szRelease;
		return szVersion;	
	}
	if(info==Os_Type)
	{
		if(vOsvi.dwPlatformId == VER_PLATFORM_WIN32_NT) return " NT ";
		if(vOsvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) return " Windows ";
		if(vOsvi.dwPlatformId == VER_PLATFORM_WIN32s) return " Win32s ";
		return __tr2qs("Unknown ");


	}
	if(info==Os_Version)
	{
		switch(iWinVersion)
		{
			case Win98:
				return "Windows 98";
			case Win98_SE:
				return "Windows 98SE";
			case WinMe:
				return "Windows Millennium" ;
			case Win2000_Professional:
				return "Windows 2000 Professional";
			case Win2000_Server: 
				return "Windows 2000 Server";
			case Win2000_Server_Datacenter:
				return "Windows 2000 Datacenter";
			case Win2000_Server_Advanced:
				return "Windows 2000 Advanced Server";
			case WinXP_Home:
				return "Windows XP Home ";
			case WinXP_Professional:
				return "Windows XP Professional" ;
			case WinServer2003:
				return "Windows Server 2003";
			case WinServer2003_Enterprise:
				return "Windows Server 2003 Enterprise";
			case	WinServer2003_Datacenter:
				return "Windows Server 2003 Datacenter";
			case WinServer2003_WebEdition:
				return "Windows Server 2003 Web Edition";
			case Win32s:
				return "Windows 32s ";
			default:
				return "Windows Unknown ";
		}
	}

	return "what's wrong? o.O";
}
#endif


namespace KviOsInfo
{
	QString type()
	{
#ifdef COMPILE_ON_WINDOWS
		return queryWinInfo(Os_Type);
#else
	#ifdef Q_OS_MACX
		return "macosx";
	#else
		return "unix";
	#endif
#endif
	}
		
	QString name()
	{
#ifdef COMPILE_ON_WINDOWS
		return "windows";
#else
		struct utsname uts;
		if(uname(&uts) == 0)
			return QString::fromLocal8Bit(uts.sysname);
		return QString::null;
#endif
	}
	
	QString version()
	{
#ifdef COMPILE_ON_WINDOWS
		return queryWinInfo(Os_Version);
#else
		struct utsname uts;
		if(uname(&uts) == 0)
			return QString::fromLocal8Bit(uts.version);
		return QString::null;
#endif
	}
	
	QString release()
	{
#ifdef COMPILE_ON_WINDOWS
		return queryWinInfo(Os_Release);
#else
		struct utsname uts;
		if(uname(&uts) == 0)
			return QString::fromLocal8Bit(uts.release);
		return QString::null;
#endif
	}
	
	QString machine()
	{
#ifdef COMPILE_ON_WINDOWS
		QString mach = getenv("PROCESSOR_IDENTIFIER");
		return mach.section(",",0,0);
#else
		struct utsname uts;
		if(uname(&uts) == 0)
			return QString::fromLocal8Bit(uts.machine);
		return QString::null;
#endif
	}
	
	QString nodename()
	{
#ifdef COMPILE_ON_WINDOWS
		return "windows";
#else
		struct utsname uts;
		if(uname(&uts) == 0)
			return QString::fromLocal8Bit(uts.nodename);
		return QString::null;
#endif
	}
	
	QString hostname()
	{
		char hbuffer[1024];
		if(gethostname(hbuffer,1024) == 0)
			return QString::fromLocal8Bit(hbuffer);
		else
			return QString::null;
	}
}