// =============================================================================
//
//      --- kvi_lineedit_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviLineEdit"

#include "kvi_lineedit_kde.h"
#include "kvi_malloc.h"
#include "kvi_mirccntrl.h"

KviLineEdit::KviLineEdit(QWidget *parent, const char *name)
	: KLineEdit(parent, name)
{
	setFocusPolicy(ClickFocus);
	m_szAltKeyCode = "";
}

KviLineEdit::~KviLineEdit()
{
	// Nothing here
}

QString KviLineEdit::text() const
{
	KviStr text(KLineEdit::text());
	char *p = (char *) kvi_malloc(text.len() + 1);
	qstrcpy(p, text.ptr());
	text = "";
	while( *p ) {
		if( *p == '~' ) {
			p++;
			switch( *p ) {
				case '~': text.append(*p);
					break;
				case 'b': text.append((char) KVI_TEXT_BOLD);
					break;
				case 'c': text.append((char) KVI_TEXT_RESET);
					break;
				case 'r': text.append((char) KVI_TEXT_REVERSE);
					break;
				case 'u': text.append((char) KVI_TEXT_UNDERLINE);
					break;
				default:
					text.append((char) KVI_TEXT_COLOR);
					text.append(*p);
			}
		} else text.append(*p);
		p++;
	}
	return QString(text.ptr());
}

void KviLineEdit::keyPressEvent(QKeyEvent *e)
{
	if( e->state() & ControlButton ) {
		switch( e->key() ) {
			case Qt::Key_B:
				KLineEdit::insert(QString("~b"));
				break;
			case Qt::Key_K:
				KLineEdit::insert(QString("~"));
				break;
			case Qt::Key_O:
				KLineEdit::insert(QString("~c"));
				break;
			case Qt::Key_R:
				KLineEdit::insert(QString("~r"));
				break;
			case Qt::Key_U:
				KLineEdit::insert(QString("~u"));
				break;
			default:
				KLineEdit::keyPressEvent(e);
		}
		return;
	}

	if( e->state() & AltButton ) {
		// Qt::Key_Meta seems to substitute Key_Alt on some keyboards
		if( (e->key() == Qt::Key_Alt) || (e->key() == Qt::Key_Meta) ) {
			m_szAltKeyCode = "";
			return;
		} else if( (e->ascii() >= '0') && (e->ascii() <= '9') ) {
			m_szAltKeyCode += e->ascii();
			return;
		}
	}

	KLineEdit::keyPressEvent(e);
}

void KviLineEdit::keyReleaseEvent(QKeyEvent *e)
{
	if( (e->key() == Qt::Key_Alt) || (e->key() == Qt::Key_Meta) ) {
		if( m_szAltKeyCode.hasData() ) {
			bool bOk;
			char ch = m_szAltKeyCode.toChar(&bOk);
			if( bOk && ch > ' ' ) {
				insert(KviStr(ch).ptr());
				e->accept();
			}
		}
		m_szAltKeyCode = "";
	}
	e->ignore();
}

void KviLineEdit::setText(const char *text)
{
	KviStr t;
	while( *text ) {
		switch( *text ) {
			case '~':
				t.append("~~");
				break;
			case KVI_TEXT_BOLD:
				t.append("~b");
				break;
			case KVI_TEXT_RESET:
				t.append("~c");
				break;
			case KVI_TEXT_REVERSE:
				t.append("~r");
				break;
			case KVI_TEXT_UNDERLINE:
				t.append("~u");
				break;
			case KVI_TEXT_COLOR:
				t.append('~');
				break;
			default:
				t.append(*text);
		}
		text++;
	}
	KLineEdit::setText(QString(t.ptr()));
}

void KviLineEdit::insert(const char *newText)
{
	KviStr t;
	while( *newText ) {
		switch( *newText ) {
			case '~':
				t.append("~~");
				break;
			case KVI_TEXT_BOLD:
				t.append("~b");
				break;
			case KVI_TEXT_RESET:
				t.append("~c");
				break;
			case KVI_TEXT_REVERSE:
				t.append("~r");
				break;
			case KVI_TEXT_UNDERLINE:
				t.append("~u");
				break;
			case KVI_TEXT_COLOR:
				t.append("~");
				break;
			default:
				t.append(*newText);
		}
		newText++;
	}
	KLineEdit::insert(QString(t.ptr()));
}

#include "m_kvi_lineedit_kde.moc"
