// =============================================================================
//
//      --- kvi_toolbarbutton_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviToolBarButton"

#include <qpainter.h>
#include <qstyle.h>
#include <qtooltip.h>

#include "kvi_string.h"
#include "kvi_toolbar.h"
#include "kvi_toolbarbutton_kde.h"

KviToolBarButton::KviToolBarButton(QWidget *parent, const char *name)
	: KToolBarButton(parent, name)
{
	if( parent->inherits("KviToolBar") )
		((KviToolBar *) parent)->insertWidget(-1, -1, this);
}

KviToolBarButton::KviToolBarButton(
	const QPixmap &pm, const char *textLabel, const char *groupText,
	QObject *receiver, const char *slot, KviToolBar *parent, const char *name)
	: KToolBarButton(pm, 0, parent, name, _CHAR_2_QSTRING(textLabel))
{
	init(parent, receiver, slot, textLabel, groupText);
}

KviToolBarButton::KviToolBarButton(
	const QString &icon, const char *textLabel, const char *groupText,
	QObject *receiver, const char *slot, KviToolBar *parent, const char *name)
	: KToolBarButton(icon, 0, parent, name, _CHAR_2_QSTRING(textLabel))
{
	init(parent, receiver, slot, textLabel, groupText);
}

void KviToolBarButton::init(
	KviToolBar *parent, QObject *receiver, const char *slot, const char *textLabel, const char *groupText)
{
	if( parent->inherits("KviToolBar") )
		((KviToolBar *) parent)->insertWidget(-1, -1, this);
	setFocusPolicy(NoFocus);
	if( slot )
		connect(this, SIGNAL(clicked()), receiver, slot);
	QString text = _CHAR_2_QSTRING(textLabel);
	QString tip  = _CHAR_2_QSTRING(groupText);

	if( !text.isEmpty() ) {
		if( !tip.isEmpty() )
			QToolTip::add(this, text, parent->mainWindow()->toolTipGroup(), tip);
		else
			QToolTip::add(this, text);
	} else if( !tip.isEmpty() ) {
		QToolTip::add(this, QString::null, parent->mainWindow()->toolTipGroup(), tip);
	}
}

KviToolBarButton::~KviToolBarButton()
{
	// Nothing here
}

void KviToolBarButton::setPixmap(const QPixmap &pm)
{
	QToolButton::setPixmap(pm);
}

void KviToolBarButton::drawButton(QPainter *p)
{
	// Allow setting a background pixmap to the toolbar
	const QPixmap *pix = ((KviToolBar *) parent())->backgroundPixmap();
	if( pix ) {
		if( !pix->isNull() ) {
			p->drawTiledPixmap(0, 0, width(), height(), *pix, x() % pix->width(), y() % pix->height());
			if( uses3D() || isDown() || isOn() ) {
				style().drawPrimitive(
					QStyle::PE_ButtonBevel, p, rect(), colorGroup(),
					(isOn() || isDown()) ? QStyle::Style_Sunken : QStyle::Style_Default
				);
			}
			drawButtonLabel(p);
			return;
		}
	}
	QToolButton::drawButton(p);
}

#include "m_kvi_toolbarbutton_kde.moc"
