// =============================================================================
//
//      --- kvi_toolbar_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qlineedit.h>
#include <qobjectlist.h>
#include <qtoolbutton.h>
#include <qtooltip.h>

#include "kvi_iconloader.h"
#include "kvi_mainwindow.h"
#include "kvi_popupmenu.h"
#include "kvi_toolbar_qt.h"

KviToolBar::KviToolBar(const QString &, KviMainWindow *mainWindow, QWidget *parent, Qt::Dock dock, bool nl, const char *name)
	: QToolBar(name, mainWindow, parent, nl, name)
{
	m_buttons.setAutoDelete(true);
	m_lineedits.setAutoDelete(true);
	if( mainWindow )
		mainWindow->addDockWindow(this, dock, nl);
}

KviToolBar::~KviToolBar()
{
	// Nothing here
}

void KviToolBar::insertLineSeparator()
{
	addSeparator();
}

int KviToolBar::insertButton(
	const QString &icon, int id, const char * /* ignored */, QObject *receiver, const char *slot,
	bool enabled, const QString &text, const QString &tooltip)
{
	QToolButton *tb = new QToolButton(KviIconLoader::loadIconSet(icon), text, tooltip, receiver, slot, this);
	tb->setEnabled(enabled);
	m_buttons.insert(id, tb);
	return m_buttons.size();
}

int KviToolBar::insertLined(
	const QString &text, int id, const char *signal, const QObject *receiver, const char *slot,
	bool enabled, const QString &toolTipText, int size, int /* ignored */)
{
	QLineEdit *le = new QLineEdit(text, this);
	QToolTip::add(le, toolTipText);
	connect(le, signal, receiver, slot);
	le->setEnabled(enabled);
	m_lineedits.insert(id, le);
	return m_lineedits.size();
}

void KviToolBar::setPreferOwnIcons(bool /* ignored */)
{
	// Nothing here
}

void KviToolBar::setItemAutoSized(int id, bool yes)
{
	if( !yes ) {
		setStretchableWidget(0);
		return;
	}
	QLineEdit *le = m_lineedits.find(id);
	if( le )
		setStretchableWidget(le);
	else {
		QToolButton *tb = m_buttons.find(id);
		if( tb ) setStretchableWidget(tb);
	}
}

void KviToolBar::setItemEnabled(int id, bool enabled)
{
	QToolButton *tb = m_buttons.find(id);
	if( tb )
		tb->setEnabled(enabled);
	else {
		QLineEdit *le = m_lineedits.find(id);
		if( le ) le->setEnabled(enabled);
	}
}

void KviToolBar::setToggle(int /* ignored */, bool /* ignored */)
{
	// This function does not do anything
}

void KviToolBar::setButton(int /* ignored */, bool /* ignored */)
{
	// This function does not do anything
}

void KviToolBar::setDelayedPopup(int id, KviPopupMenu *m)
{
	QToolButton *tb = m_buttons.find(id);
	if( tb ) {
		tb->setPopup(m);
		tb->setPopupDelay(2000);
	}
}

QToolButton *KviToolBar::getButton(int id)
{
	return m_buttons.find(id);
}

QString KviToolBar::getLinedText(int id) const
{
	QLineEdit *le = m_lineedits.find(id);
	if( le )
		return le->text();
	return QString::null;
}

void KviToolBar::setButtonIcon(int id, const QString &icon)
{
	QToolButton *tb = m_buttons.find(id);
	if( tb )
		tb->setIconSet(KviIconLoader::loadIconSet(icon));
}

void KviToolBar::setButtonText(int id, const QString &text, bool /* ignored */)
{
	QToolButton *tb = m_buttons.find(id);
	if( tb )
		tb->setTextLabel(text);
}

void KviToolBar::toggleBigIcons(bool on)
{
	QObjectList *l = queryList("QToolButton");
	QObjectListIt iter(*l);
	QToolButton *tb;
	for( ; iter.current(); ++iter ) {
		tb = (QToolButton *) iter.current();
		tb->setUsesBigPixmap(on);
	}
	delete l;
}

void KviToolBar::toggleIconText(bool on)
{
	QObjectList *l = queryList("QToolButton");
	QObjectListIt iter(*l);
	QToolButton *tb;
	for( ; iter.current(); ++iter ) {
		tb = (QToolButton *) iter.current();
		tb->setUsesTextLabel(on);
	}
	delete l;
}

#include "m_kvi_toolbar_qt.moc"
