// =============================================================================
//
//      --- kvi_toolbarbutton_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviToolBarButton"

#include <qpainter.h>
#include <qstyle.h>

#include "kvi_iconloader.h"
#include "kvi_string.h"
#include "kvi_toolbar.h"
#include "kvi_toolbarbutton_qt.h"

KviToolBarButton::KviToolBarButton(QWidget *parent, const char *name)
	: QToolButton(parent, name)
{
	// Nothing here
}

KviToolBarButton::KviToolBarButton(
	const QString &icon, const char *textLabel, const char *groupText,
	QObject *receiver, const char *slot, KviToolBar *parent, const char *name)
	: QToolButton(
		KviIconLoader::loadIcon(icon), _CHAR_2_QSTRING(textLabel), _CHAR_2_QSTRING(groupText), receiver, slot, parent, name
	)
{
	setFocusPolicy(NoFocus);
}

KviToolBarButton::KviToolBarButton(
	const QPixmap &pm, const char *textLabel, const char *groupText,
	QObject *receiver, const char *slot, KviToolBar *parent, const char *name)
	: QToolButton(pm, _CHAR_2_QSTRING(textLabel), _CHAR_2_QSTRING(groupText), receiver, slot, parent, name)
{
	setFocusPolicy(NoFocus);
}

KviToolBarButton::~KviToolBarButton()
{
	// Nothing here
}

void KviToolBarButton::drawButton(QPainter *p)
{
	// Allow setting a background pixmap to the toolbar
	const QPixmap *pix = ((KviToolBar *) parent())->backgroundPixmap();
	if( pix ) {
		if( !pix->isNull() ) {
			p->drawTiledPixmap(0, 0, width(), height(), *pix, x() % pix->width(), y() % pix->height());
			if( uses3D() || isDown() || isOn() ) {
				style().drawPrimitive(
					QStyle::PE_ButtonBevel, p, rect(), colorGroup(),
					(isOn() || isDown()) ? QStyle::Style_Sunken : QStyle::Style_Default
				);
			}
			drawButtonLabel(p);
			return;
		}
	}
	QToolButton::drawButton(p);
}

void KviToolBarButton::setIcon(const QString &icon)
{
	setPixmap(KviIconLoader::loadIcon(icon));
}

#include "m_kvi_toolbarbutton_qt.moc"
