// =============================================================================
//
//      --- kvi_irc_proxylist.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviIrcProxyList"

#include "kvi_debug.h"
#include "kvi_irc_proxylist.h"

// TODO: Move to KviListView implementation...

/**
 * A proxy entry list item for KviListView
 */
KviIrcProxyListItem::KviIrcProxyListItem(KviListView *w, KviIrcProxy *ptr)
	: KviListViewItem(w
	, ptr->szHost.ptr()
	, ptr->szPort.ptr()
	, ptr->szUsername.ptr()
	, ptr->szPassword.ptr()
	, ptr->addresses.first().isNull() ? "" : ptr->addresses.first().toString().ascii()
	)
{
	__range_valid(ptr);
	m_ptr = ptr;
}

KviIrcProxyListItem::~KviIrcProxyListItem()
{
	// Nothing here
}
