// =============================================================================
//
//      --- kvi_regusers.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviRegisteredUsers"

#include <qlayout.h>
#include <qtooltip.h>

#define _KVI_REGUSERS_CPP_

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_iconloader.h"
#include "kvi_integerselector.h"
#include "kvi_listview.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"
#include "kvi_options.h"
#include "kvi_pushbutton.h"
#include "kvi_regusers.h"
#include "kvi_regusersdb.h"

// TODO: save geometry of this dialog! (kvi_options.cpp, i guess)

KviRegisteredUsers::KviRegisteredUsers(QWidget *parent)
	: KviTabDialog(parent, "regusers", false, _i18n_("KVIrc: Registered Users"))
{
	setIcon(KviIconLoader::loadIcon(tb_regUsers));

	// ================================
	// Registered users - tab
	// ================================
	QFrame      *tab = addPage(_CHAR_2_QSTRING(_i18n_("&User Database")));
	QGridLayout *g   = new QGridLayout(tab, 2, 2, 10, 4);

	// Add another field???
	// ---> something like the name in eggdrop...
	// (like a static nick, as unique identifier)
	m_pRegBox = new KviListView(tab, "registered_users", true);
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Nickname")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Username")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Hostname")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Flags")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Password")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(_i18n_("Comment")));
	QToolTip::add(m_pRegBox->viewport(), _i18n_(
		"Built-in flags:\n"\
		"b: Beep\n"\
		"n: Notify\n"\
		"i: Ignore")
	);

	KviListViewItem *it;
	KviRegisteredUser *u;
	for( u = g_pOptions->m_pRegUsersDb->m_pRegList->first(); u; u = g_pOptions->m_pRegUsersDb->m_pRegList->next() ) {
		it = new KviListViewItem(m_pRegBox,
			_CHAR_2_QSTRING(u->user.nick()),
			_CHAR_2_QSTRING(u->user.username()),
			_CHAR_2_QSTRING(u->user.host()),
			_CHAR_2_QSTRING(u->allFlags.ptr()),
			_CHAR_2_QSTRING(u->passwd.ptr()),
			_CHAR_2_QSTRING(u->comment.ptr())
		);
	}
	g->addMultiCellWidget(m_pRegBox, 0, 0, 0, 1);

	KviPushButton *btn = new KviPushButton(_CHAR_2_QSTRING(_i18n_("&Add User")), tab);
	connect(btn, SIGNAL(clicked()), this, SLOT(addNewUser()));
	g->addWidget(btn, 1, 0);

	btn = new KviPushButton(_CHAR_2_QSTRING(_i18n_("&Remove User")), tab);
	connect(btn, SIGNAL(clicked()), this, SLOT(removeSelectedUsers()));
	g->addWidget(btn, 1, 1);

	g->activate();

	// ================================
	// Options - tab
	// ================================
	tab = addPage(_CHAR_2_QSTRING(_i18n_("&Notify && Ignore")));
	g = new QGridLayout(tab, 8, 1, 10, 4);

	KviBoolSelector *b1 = new KviBoolSelector(tab, _i18n_("Enable notify list"), &(g_pOptions->m_bEnableNotifyList));
	g->addWidget(b1, 0, 0);

	KviBoolSelector *b = new KviBoolSelector(tab,
		_i18n_("Use DALnet 'watch' method"),
		&(g_pOptions->m_bEnableDalNetStyleNotifyMethod), g_pOptions->m_bEnableNotifyList
	);
	g->addWidget(b, 1, 0);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));

	KviIntegerSelector *i = new KviIntegerSelector(tab,
		_i18n_("Notify list check timeout:"),
		&(g_pOptions->m_iNotifyListCheckTimeoutInSecs), KviIntegerSelector::Int,
		10, 65535, 60, g_pOptions->m_bEnableNotifyList, 100, 0,
		_i18n_(" second(s)")
	);
	g->addWidget(i, 2, 0);
	connect(b1, SIGNAL(toggled(bool)), i, SLOT(setEnabled(bool)));

	QFrame *r = new QFrame(tab);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(r, 3, 0);

	b = new KviBoolSelector(tab, _i18n_("Enable ignore on privmsg"), &(g_pOptions->m_bEnableIgnoreOnPrivmsg));
	g->addWidget(b, 4, 0);
	b = new KviBoolSelector(tab, _i18n_("Enable ignore on notice"), &(g_pOptions->m_bEnableIgnoreOnNotice));
	g->addWidget(b, 5, 0);
	b = new KviBoolSelector(tab, _i18n_("Verbose ignore"), &(g_pOptions->m_bVerboseIgnore));
	g->addWidget(b, 6, 0);

	r = new QFrame(tab);
	g->addWidget(r, 7, 0);
	g->setRowStretch(7, 1);

	g->activate();

	// ================================
	// Common buttons
	// ================================
	setButtonHelpText(_CHAR_2_QSTRING(_i18n_("What is &This?")));
	connect(this, SIGNAL(helpClicked()), g_pApp, SLOT(slot_whatIsThisRequest()));
	setButtonOK();
	setButtonCancel();
}

KviRegisteredUsers::~KviRegisteredUsers()
{
	// Nothing here
}

void KviRegisteredUsers::addNewUser()
{
	KviListViewItem *it;
	it = new KviListViewItem(
		m_pRegBox, _CHAR_2_QSTRING("*"), _CHAR_2_QSTRING("*"), _CHAR_2_QSTRING("*"), _CHAR_2_QSTRING("")
	);
}

void KviRegisteredUsers::removeSelectedUsers()
{
	KviListViewItem *it = m_pRegBox->firstChild();
	while( it ) {
		KviListViewItem *aux = it;
		it = it->nextSibling();
		if( aux->isSelected() ) delete aux;
	}
}

void KviRegisteredUsers::done(int r)
{
	KviTabDialog::done(r);

	if( r == Accepted ) {
		KviBoolSelector::commitAll(this);
		KviIntegerSelector::commitAll(this);

		g_pOptions->m_pRegUsersDb->clear(); // Autodelete is true!
		KviListViewItem *it = m_pRegBox->firstChild();
		while( it ) {
			KviStr nick = it->text(0);    // Nickname
			nick.stripWhiteSpace();
			KviStr user = it->text(1);    // User
			user.stripWhiteSpace();
			if( user.isEmpty() )
				user = "*";
			KviStr host = it->text(2);    // Host
			host.stripWhiteSpace();
			if( host.isEmpty() )
				host = "*";
			KviStr flag = it->text(3);    // Flags
			flag.stripWhiteSpace();
			KviStr passwd = it->text(4);  // Password
			passwd.stripWhiteSpace();
			KviStr comment = it->text(5); // Comment
			comment.stripWhiteSpace();

			if( nick.hasData() ) {
				KviRegisteredUser *u = new KviRegisteredUser();
				u->user.setNick(nick.ptr());
				u->user.setUsername(user.ptr());
				u->user.setHost(host.ptr());
				g_pOptions->m_pRegUsersDb->registerUser(u, flag.ptr());
				g_pOptions->m_pRegUsersDb->setPasswd(u, passwd.ptr());
				g_pOptions->m_pRegUsersDb->setComment(u, comment.ptr());
			}
			it = it->nextSibling();
		}
	}
	emit finished((r == Accepted));
}

void KviRegisteredUsers::closeEvent(QCloseEvent *)
{
	emit finished(false);
}

#include "m_kvi_regusers.moc"
