#ifndef _KVI_TASKBAR_H_INCLUDED_
#define _KVI_TASKBAR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_taskbar.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_toolbar.h"

class QPixmap;

class KviFrame;
class KviTaskBarButton;
class KviTransparentWidget;
class KviWindow;

class KviTaskBar : public KviToolBar
{
	friend class KviTaskBarButton;

	Q_OBJECT
public:
	KviTaskBar(KviFrame *parent);
	~KviTaskBar();

	KviTaskBarButton *getButton      (KviWindow *);
	KviTaskBarButton *addWinButton   (KviWindow *);
	void              removeWinButton(KviWindow *);
	void              setActiveButton(KviWindow *);
	void              windowAttached (KviWindow *, bool bAttached);

	virtual void fontChange(const QFont &oldFont);

	KviTaskBarButton *getNextWindowButton(bool bRight, KviWindow *);
protected slots:
	void setupMinimumSizes(Orientation);
protected:
	void  buttonLeftClicked(KviWindow *, KviTaskBarButton *);
	void buttonRightClicked(KviWindow *, KviTaskBarButton *);
	void layoutButtons();
	void recalcButtonHeight();
	virtual void resizeEvent(QResizeEvent *);
	virtual QSizePolicy sizePolicy();
private:
	KviTransparentWidget       *m_pBase;
	QPtrList<KviTaskBarButton> *m_pButtonList;
	int                         m_iButtonHeight;
	QPixmap                    *m_pMemBuffer;
	KviFrame                   *m_pFrm;
};

#endif // _KVI_TASKBAR_H_INCLUDED_
